/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.ui;

import com.evacipated.cardcrawl.modthespire.ui.JModPanelCheckBoxList;
import com.evacipated.cardcrawl.modthespire.ui.ModPanel;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.io.IOException;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

class ListItemTransferHandler
extends TransferHandler {
    protected final DataFlavor localObjectFlavor = new DataFlavor(Object[].class, "Array of items");
    protected int[] indices;
    protected int addIndex = -1;
    protected int addCount;

    @Override
    protected Transferable createTransferable(JComponent c) {
        JList source = (JList)c;
        c.getRootPane().getGlassPane().setVisible(true);
        this.indices = source.getSelectedIndices();
        final Object[] transferedObjects = source.getSelectedValuesList().toArray(new Object[0]);
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{ListItemTransferHandler.this.localObjectFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return Objects.equals(ListItemTransferHandler.this.localObjectFlavor, flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return transferedObjects;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
    }

    @Override
    public int getSourceActions(JComponent c) {
        Component glassPane = c.getRootPane().getGlassPane();
        glassPane.setCursor(DragSource.DefaultMoveDrop);
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        TransferHandler.DropLocation tdl = info.getDropLocation();
        if (!this.canImport(info) || !(tdl instanceof JList.DropLocation)) {
            return false;
        }
        JList.DropLocation dl = (JList.DropLocation)tdl;
        JList target = (JList)info.getComponent();
        DefaultListModel listModel = (DefaultListModel)target.getModel();
        int max = listModel.getSize();
        int index = dl.getIndex();
        index = index < 0 ? max : index;
        this.addIndex = index = Math.min(index, max);
        try {
            Object[] values = (Object[])info.getTransferable().getTransferData(this.localObjectFlavor);
            for (int i = 0; i < values.length; ++i) {
                int idx = index++;
                ((ModPanel)values[i]).checkBox.addItemListener(event -> ((JModPanelCheckBoxList)target).publishBoxChecked());
                listModel.add(idx, values[i]);
                target.addSelectionInterval(idx, idx);
            }
            this.addCount = values.length;
            return true;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        c.getRootPane().getGlassPane().setVisible(false);
        this.cleanup(c, action == 2);
    }

    private void cleanup(JComponent c, boolean remove) {
        if (remove && Objects.nonNull(this.indices)) {
            if (this.addCount > 0) {
                for (int i = 0; i < this.indices.length; ++i) {
                    if (this.indices[i] < this.addIndex) continue;
                    int n = i;
                    this.indices[n] = this.indices[n] + this.addCount;
                }
            }
            JList source = (JList)c;
            DefaultListModel model = (DefaultListModel)source.getModel();
            for (int i = this.indices.length - 1; i >= 0; --i) {
                model.remove(this.indices[i]);
            }
        }
        this.indices = null;
        this.addCount = 0;
        this.addIndex = -1;
    }
}

