/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.ui;

import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.ui.ListItemTransferHandler;
import com.evacipated.cardcrawl.modthespire.ui.ModPanel;
import com.evacipated.cardcrawl.modthespire.ui.ModSelectWindow;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class JModPanelCheckBoxList
extends JList<ModPanel> {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private ModSelectWindow parent;

    public JModPanelCheckBoxList(final ModSelectWindow parent) {
        this.parent = parent;
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setSelectionMode(0);
        this.setTransferHandler(new ListItemTransferHandler());
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = JModPanelCheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    ModPanel modPanel = (ModPanel)JModPanelCheckBoxList.this.getModel().getElementAt(index);
                    parent.setModInfo(modPanel.info);
                    if (e.getX() <= modPanel.checkBox.getWidth() && modPanel.checkBox.isEnabled()) {
                        modPanel.checkBox.setSelected(!modPanel.checkBox.isSelected());
                        JModPanelCheckBoxList.this.repaint();
                    }
                }
            }
        });
        this.publishBoxChecked();
    }

    public void publishBoxChecked() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ((ModPanel)this.getModel().getElementAt(i)).recalcModWarnings(this);
        }
    }

    public JModPanelCheckBoxList(ModSelectWindow parent, DefaultListModel<ModPanel> model) {
        this(parent);
        this.setModel(model);
    }

    public File[] getCheckedMods() {
        int size = 0;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!((ModPanel)this.getModel().getElementAt(i)).isSelected()) continue;
            ++size;
        }
        File[] ret = new File[size];
        int j = 0;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!((ModPanel)this.getModel().getElementAt(i)).isSelected()) continue;
            ret[j] = ((ModPanel)this.getModel().getElementAt((int)i)).modFile;
            ++j;
        }
        return ret;
    }

    public void toggleAllMods() {
        int i;
        int on = 0;
        for (i = 0; i < this.getModel().getSize(); ++i) {
            if (!((ModPanel)this.getModel().getElementAt(i)).isSelected()) continue;
            ++on;
        }
        if (on >= this.getModel().getSize() / 2) {
            for (i = 0; i < this.getModel().getSize(); ++i) {
                ((ModPanel)this.getModel().getElementAt(i)).setSelected(false);
            }
        } else {
            for (i = 0; i < this.getModel().getSize(); ++i) {
                ((ModPanel)this.getModel().getElementAt(i)).setSelected(true);
            }
        }
        this.publishBoxChecked();
    }

    public synchronized void setUpdateIcon(ModInfo info, ModSelectWindow.UpdateIconType type) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!info.equals(((ModPanel)this.getModel().getElementAt((int)i)).info)) continue;
            ((ModPanel)this.getModel().getElementAt(i)).setUpdateIcon(type);
            break;
        }
        this.repaint();
    }

    protected class CellRenderer
    implements ListCellRenderer<ModPanel> {
        protected CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ModPanel> list, ModPanel value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = value.checkBox;
            value.setBackground(isSelected ? JModPanelCheckBoxList.this.getSelectionBackground() : JModPanelCheckBoxList.this.getBackground());
            value.setForeground(isSelected ? JModPanelCheckBoxList.this.getSelectionForeground() : JModPanelCheckBoxList.this.getForeground());
            checkbox.setFont(JModPanelCheckBoxList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(false);
            return value;
        }
    }
}

