/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.evacipated.cardcrawl.modthespire.patcher.ByRefParameterNotArrayException;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;

public class PrefixPatchInfo
extends PatchInfo {
    public PrefixPatchInfo(CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        super(ctMethodToPatch, patchMethod);
    }

    @Override
    protected String debugMsg() {
        return "Adding Prefix...";
    }

    @Override
    public int patchOrdering() {
        return 1;
    }

    @Override
    public void doPatch() throws PatchingException {
        try {
            String src = "{\n";
            String funccall = this.patchMethod.getDeclaringClass().getName() + "." + this.patchMethod.getName() + "(";
            String postcallsrc = "";
            String postcallsrc2 = "";
            int paramOffset = Modifier.isStatic(this.ctMethodToPatch.getModifiers()) ? 1 : 0;
            CtClass[] prefixParamTypes = this.patchMethod.getParameterTypes();
            Object[][] prefixParamAnnotations = this.patchMethod.getParameterAnnotations();
            for (int i = 0; i < prefixParamTypes.length; ++i) {
                if (PrefixPatchInfo.paramByRef(prefixParamAnnotations[i])) {
                    if (!prefixParamTypes[i].isArray()) {
                        throw new ByRefParameterNotArrayException(i);
                    }
                    String tmp = prefixParamTypes[i].getName();
                    String paramTypeName = tmp.substring(0, tmp.indexOf(91) + 1);
                    paramTypeName = paramTypeName + "1" + tmp.substring(tmp.indexOf(91) + 1);
                    src = src + prefixParamTypes[i].getName() + " __param" + i + " = new " + paramTypeName + ";\n";
                    src = src + "__param" + i + "[0] = $" + (i + paramOffset) + ";\n";
                    funccall = funccall + "__param" + i;
                    postcallsrc = postcallsrc + "$" + (i + paramOffset) + " = ";
                    postcallsrc2 = postcallsrc2 + "$" + (i + paramOffset) + " = ";
                    String typename = PrefixPatchInfo.paramByRefTypename2(this.ctMethodToPatch, i);
                    if (!typename.isEmpty()) {
                        postcallsrc = postcallsrc + "(" + typename + ")";
                        postcallsrc2 = postcallsrc2 + "(com.megacrit.cardcrawl." + typename + ")";
                    }
                    postcallsrc = postcallsrc + "__param" + i + "[0];\n";
                    postcallsrc2 = postcallsrc2 + "__param" + i + "[0];\n";
                } else {
                    funccall = funccall + "$" + (i + paramOffset);
                }
                if (i >= prefixParamTypes.length - 1) continue;
                funccall = funccall + ", ";
            }
            CtClass returnType = this.patchMethod.getReturnType();
            boolean hasEarlyReturn = false;
            if (this.ctMethodToPatch instanceof CtMethod && !returnType.equals(CtPrimitiveType.voidType) && returnType.equals(returnType.getClassPool().get(SpireReturn.class.getName()))) {
                hasEarlyReturn = true;
            } else if (this.ctMethodToPatch instanceof CtConstructor && !returnType.equals(CtPrimitiveType.voidType) && returnType.equals(returnType.getClassPool().get(SpireReturn.class.getName()))) {
                hasEarlyReturn = true;
            }
            funccall = hasEarlyReturn ? SpireReturn.class.getName() + " opt = " + funccall + ");\n" : funccall + ");\n";
            String src2 = src = src + funccall;
            src = src + postcallsrc;
            src2 = src2 + postcallsrc2;
            if (hasEarlyReturn) {
                String earlyReturn = "if (opt.isPresent()) { return";
                if (this.ctMethodToPatch instanceof CtMethod && !((CtMethod)this.ctMethodToPatch).getReturnType().equals(CtPrimitiveType.voidType)) {
                    CtClass toPatchReturnType = ((CtMethod)this.ctMethodToPatch).getReturnType();
                    String toPatchReturnTypeName = toPatchReturnType.getName();
                    if (toPatchReturnType.isPrimitive()) {
                        toPatchReturnTypeName = toPatchReturnType.equals(CtPrimitiveType.intType) ? "Integer" : (toPatchReturnType.equals(CtPrimitiveType.charType) ? "Character" : toPatchReturnTypeName.substring(0, 1).toUpperCase() + toPatchReturnTypeName.substring(1));
                        earlyReturn = earlyReturn + " (";
                    }
                    earlyReturn = earlyReturn + " (" + toPatchReturnTypeName + ")opt.get()";
                    if (toPatchReturnType.isPrimitive()) {
                        earlyReturn = earlyReturn + ")." + toPatchReturnType.getName() + "Value()";
                    }
                }
                earlyReturn = earlyReturn + "; }\n";
                src = src + earlyReturn;
                src2 = src2 + earlyReturn;
            }
            src = src + "}";
            src2 = src2 + "}";
            if (Loader.DEBUG) {
                System.out.println(src);
            }
            try {
                if (this.ctMethodToPatch instanceof CtConstructor && !((CtConstructor)this.ctMethodToPatch).isClassInitializer()) {
                    ((CtConstructor)this.ctMethodToPatch).insertBeforeBody(src);
                } else {
                    this.ctMethodToPatch.insertBefore(src);
                }
            }
            catch (CannotCompileException e) {
                try {
                    if (this.ctMethodToPatch instanceof CtConstructor) {
                        ((CtConstructor)this.ctMethodToPatch).insertBeforeBody(src2);
                    } else {
                        this.ctMethodToPatch.insertBefore(src2);
                    }
                }
                catch (CannotCompileException e2) {
                    throw e;
                }
            }
        }
        catch (ClassNotFoundException | CannotCompileException | NotFoundException e) {
            throw new PatchingException(e);
        }
    }
}

