/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CtBehavior;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;

public abstract class PatchInfo {
    private static int modNum = 0;
    private int modOrder;
    CtBehavior ctMethodToPatch;
    CtMethod patchMethod;

    public PatchInfo(CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        this.ctMethodToPatch = ctMethodToPatch;
        this.patchMethod = patchMethod;
        this.modOrder = modNum;
    }

    public void debugPrint() {
        System.out.println("Patch Class: [" + this.patchClassName() + "]");
        System.out.println(" - Patching [" + this.ctMethodToPatch.getLongName() + "]");
        System.out.printf(" - ", new Object[0]);
        System.out.println(this.debugMsg());
    }

    protected String patchClassName() {
        return this.patchMethod.getDeclaringClass().getName();
    }

    protected abstract String debugMsg();

    public static void nextMod() {
        ++modNum;
    }

    public final int modOrdering() {
        return this.modOrder;
    }

    public abstract int patchOrdering();

    public abstract void doPatch() throws PatchingException;

    protected static boolean paramByRef(Object[] annotations) {
        for (Object o : annotations) {
            if (!(o instanceof ByRef)) continue;
            return true;
        }
        return false;
    }

    protected static String paramByRefTypename(Object[] annotations) {
        for (Object o : annotations) {
            if (!(o instanceof ByRef)) continue;
            return ((ByRef)o).type();
        }
        return "";
    }

    protected static String paramByRefTypename2(CtBehavior ctMethodToPatch, int index) throws NotFoundException {
        if (!Modifier.isStatic(ctMethodToPatch.getModifiers())) {
            --index;
        }
        try {
            return ctMethodToPatch.getParameterTypes()[index].getName();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

