/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.evacipated.cardcrawl.modthespire.patcher.ByRefParameterNotArrayException;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;

public class InsertPatchInfo
extends PatchInfo {
    private SpireInsertPatch info;
    private List<LineNumberAndPatchType> locs;

    public InsertPatchInfo(SpireInsertPatch info, List<LineNumberAndPatchType> locs, CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        super(ctMethodToPatch, patchMethod);
        this.info = info;
        this.locs = locs;
    }

    @Override
    protected String debugMsg() {
        StringBuilder msgBuilder = new StringBuilder("");
        for (LineNumberAndPatchType patchLoc : this.locs) {
            switch (patchLoc.patchType) {
                case ABSOLUTE: {
                    msgBuilder.append("Adding Insert @ " + patchLoc.lineNumber + "...\n");
                    break;
                }
                case RELATIVE: {
                    msgBuilder.append("Adding Insert @ r" + patchLoc.relativeLineNumber + " (abs:" + patchLoc.lineNumber + ")...\n");
                }
            }
        }
        return msgBuilder.toString();
    }

    @Override
    public int patchOrdering() {
        return -2;
    }

    private void doPatch(int loc) throws NotFoundException, ClassNotFoundException, CannotCompileException, PatchingException {
        int i;
        CtClass returnType = this.patchMethod.getReturnType();
        boolean hasEarlyReturn = false;
        if (this.ctMethodToPatch instanceof CtMethod && !returnType.equals(CtPrimitiveType.voidType) && returnType.equals(returnType.getClassPool().get(SpireReturn.class.getName()))) {
            hasEarlyReturn = true;
        } else if (this.ctMethodToPatch instanceof CtConstructor && !returnType.equals(CtPrimitiveType.voidType) && returnType.equals(returnType.getClassPool().get(SpireReturn.class.getName()))) {
            hasEarlyReturn = true;
        }
        CtClass[] insertParamTypes = this.patchMethod.getParameterTypes();
        Object[][] insertParamAnnotations = this.patchMethod.getParameterAnnotations();
        int insertParamsStartIndex = this.ctMethodToPatch.getParameterTypes().length;
        if (!Modifier.isStatic(this.ctMethodToPatch.getModifiers())) {
            ++insertParamsStartIndex;
        }
        String[] localVarTypeNames = new String[insertParamAnnotations.length - insertParamsStartIndex];
        for (int i2 = insertParamsStartIndex; i2 < insertParamAnnotations.length; ++i2) {
            if (!InsertPatchInfo.paramByRef(insertParamAnnotations[i2])) continue;
            if (!insertParamTypes[i2].isArray()) {
                throw new ByRefParameterNotArrayException(i2);
            }
            localVarTypeNames[i2 - insertParamsStartIndex] = insertParamTypes[i2].getName();
        }
        String src = "{\n";
        if (this.info != null) {
            for (i = 0; i < this.info.localvars().length; ++i) {
                if (i >= localVarTypeNames.length) {
                    throw new PatchingException("Insufficient method parameters to accept localvars");
                }
                if (localVarTypeNames[i] == null) continue;
                String tmp = localVarTypeNames[i].substring(0, localVarTypeNames[i].indexOf(91) + 1);
                tmp = tmp + "1" + localVarTypeNames[i].substring(localVarTypeNames[i].indexOf(91) + 1);
                src = src + localVarTypeNames[i] + " __" + this.info.localvars()[i] + " = new " + tmp + ";\n";
                src = src + "__" + this.info.localvars()[i] + "[0] = " + this.info.localvars()[i] + ";\n";
            }
        }
        if (hasEarlyReturn) {
            src = src + SpireReturn.class.getName() + " opt = ";
        }
        src = src + this.patchMethod.getDeclaringClass().getName() + "." + this.patchMethod.getName() + "(";
        if (!Modifier.isStatic(this.ctMethodToPatch.getModifiers())) {
            if (src.charAt(src.length() - 1) != '(') {
                src = src + ", ";
            }
            src = src + "$0";
        }
        if (src.charAt(src.length() - 1) != '(') {
            src = src + ", ";
        }
        src = src + "$$";
        if (this.info != null) {
            for (i = 0; i < this.info.localvars().length; ++i) {
                src = src + ", ";
                if (localVarTypeNames[i] != null) {
                    src = src + "__";
                }
                src = src + this.info.localvars()[i];
            }
        }
        String src2 = src = src + ");\n";
        if (this.info != null) {
            for (int i3 = 0; i3 < this.info.localvars().length; ++i3) {
                if (localVarTypeNames[i3] == null) continue;
                src = src + this.info.localvars()[i3] + " = ";
                src2 = src2 + this.info.localvars()[i3] + " = ";
                String typename = InsertPatchInfo.paramByRefTypename(insertParamAnnotations[i3 + insertParamsStartIndex]);
                if (!typename.isEmpty()) {
                    src = src + "(" + typename + ")";
                    src2 = src2 + "(com.megacrit.cardcrawl." + typename + ")";
                }
                src = src + "__" + this.info.localvars()[i3] + "[0];\n";
                src2 = src2 + "__" + this.info.localvars()[i3] + "[0];\n";
            }
        }
        if (hasEarlyReturn) {
            String earlyReturn = "if (opt.isPresent()) { return";
            if (this.ctMethodToPatch instanceof CtMethod && !((CtMethod)this.ctMethodToPatch).getReturnType().equals(CtPrimitiveType.voidType)) {
                CtClass toPatchReturnType = ((CtMethod)this.ctMethodToPatch).getReturnType();
                String toPatchReturnTypeName = toPatchReturnType.getName();
                if (toPatchReturnType.isPrimitive()) {
                    toPatchReturnTypeName = toPatchReturnType.equals(CtPrimitiveType.intType) ? "Integer" : (toPatchReturnType.equals(CtPrimitiveType.charType) ? "Character" : toPatchReturnTypeName.substring(0, 1).toUpperCase() + toPatchReturnTypeName.substring(1));
                    earlyReturn = earlyReturn + " (";
                }
                earlyReturn = earlyReturn + " (" + toPatchReturnTypeName + ")opt.get()";
                if (toPatchReturnType.isPrimitive()) {
                    earlyReturn = earlyReturn + ")." + toPatchReturnType.getName() + "Value()";
                }
            }
            earlyReturn = earlyReturn + "; }\n";
            src = src + earlyReturn;
            src2 = src2 + earlyReturn;
        }
        src = src + "}";
        src2 = src2 + "}";
        try {
            this.ctMethodToPatch.insertAt(loc, src);
            if (Loader.DEBUG) {
                System.out.println(src);
            }
        }
        catch (CannotCompileException e) {
            try {
                this.ctMethodToPatch.insertAt(loc, src2);
                if (Loader.DEBUG) {
                    System.out.println(src2);
                }
            }
            catch (CannotCompileException e2) {
                if (Loader.DEBUG) {
                    System.out.println(src);
                }
                throw e;
            }
        }
    }

    @Override
    public void doPatch() throws PatchingException {
        for (LineNumberAndPatchType patchLoc : this.locs) {
            try {
                this.doPatch(patchLoc.lineNumber);
            }
            catch (ClassNotFoundException | CannotCompileException | NotFoundException e) {
                throw new PatchingException(e);
            }
        }
    }

    public static enum InsertPatchType {
        ABSOLUTE,
        RELATIVE;

    }

    public static class LineNumberAndPatchType {
        public int lineNumber;
        public int relativeLineNumber;
        public InsertPatchType patchType;

        public LineNumberAndPatchType(int lineNumber) {
            this.lineNumber = lineNumber;
            this.patchType = InsertPatchType.ABSOLUTE;
        }

        public LineNumberAndPatchType(int lineNumber, int relativeLineNumber) {
            this.lineNumber = lineNumber;
            this.relativeLineNumber = relativeLineNumber;
            this.patchType = InsertPatchType.RELATIVE;
        }
    }
}

