/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.lib.SpireField;
import com.evacipated.cardcrawl.modthespire.lib.StaticSpireField;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import java.lang.reflect.Proxy;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationImpl;

public class ClassPatchInfo
extends PatchInfo {
    private CtClass ctPatchClass;
    private CtClass ctClassToPatch;

    public ClassPatchInfo(CtClass ctClassToPatch, CtClass ctPatchClass) {
        super(null, null);
        this.ctClassToPatch = ctClassToPatch;
        this.ctPatchClass = ctPatchClass;
    }

    @Override
    public void debugPrint() {
        System.out.println("Patch Class: [" + this.patchClassName() + "]");
        System.out.println(" - Patching [" + this.ctClassToPatch.getName() + "]");
    }

    @Override
    protected String debugMsg() {
        return "";
    }

    @Override
    protected String patchClassName() {
        return this.ctPatchClass.getName();
    }

    @Override
    public int patchOrdering() {
        return -5;
    }

    @Override
    public void doPatch() throws PatchingException {
        try {
            block4: for (CtField f : this.ctPatchClass.getDeclaredFields()) {
                boolean isSpireField;
                boolean isStatic = f.getType().getName().equals(StaticSpireField.class.getCanonicalName());
                boolean bl = isSpireField = isStatic || f.getType().getName().equals(SpireField.class.getCanonicalName());
                if (!isSpireField) continue;
                int tries = 100;
                while (tries > 0) {
                    --tries;
                    String fieldName = String.format("%s_%d", f.getName(), new Random().nextInt(1000));
                    String fieldType = f.getGenericSignature();
                    Pattern pattern = Pattern.compile("Lcom/evacipated/cardcrawl/modthespire/lib/(?:Static)?SpireField<L(.+);>;");
                    Matcher matcher = pattern.matcher(fieldType);
                    matcher.find();
                    fieldType = matcher.group(1).replace('/', '.');
                    if (fieldType.contains("<")) {
                        fieldType = fieldType.substring(0, fieldType.indexOf(60));
                    }
                    String str = String.format("public%s %s %s;", isStatic ? " static" : "", fieldType, fieldName);
                    if (Loader.DEBUG) {
                        System.out.println(" - Adding Field: " + str);
                    }
                    CtField new_f = CtField.make(str, this.ctClassToPatch);
                    ConstPool constPool = this.ctClassToPatch.getClassFile().getConstPool();
                    AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                    for (Object a : f.getAvailableAnnotations()) {
                        if (!(Proxy.getInvocationHandler(a) instanceof AnnotationImpl)) continue;
                        if (Loader.DEBUG) {
                            System.out.println("   - Copying annotation: " + a);
                        }
                        AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(a);
                        Annotation annotation = new Annotation(impl.getTypeName(), constPool);
                        if (impl.getAnnotation().getMemberNames() != null) {
                            for (Object memberName : impl.getAnnotation().getMemberNames()) {
                                annotation.addMemberValue((String)memberName, impl.getAnnotation().getMemberValue((String)memberName));
                            }
                        }
                        attr.addAnnotation(annotation);
                    }
                    new_f.getFieldInfo().addAttribute(attr);
                    String expr = String.format("(%s) %s.%s.getDefaultValue()", fieldType, this.ctPatchClass.getName(), f.getName());
                    try {
                        this.ctClassToPatch.addField(new_f, CtField.Initializer.byExpr(expr));
                    }
                    catch (DuplicateMemberException e) {
                        if (tries != 0) continue;
                        throw e;
                    }
                    CtConstructor staticinit = this.ctPatchClass.getClassInitializer();
                    if (staticinit == null) {
                        staticinit = this.ctPatchClass.makeClassInitializer();
                    }
                    String src = String.format("{\nif (%s == null) { %s = new %s(null); }\n%s.initialize(%s, \"%s\");\n}", f.getName(), f.getName(), isStatic ? StaticSpireField.class.getCanonicalName() : SpireField.class.getCanonicalName(), f.getName(), this.ctClassToPatch.getName() + ".class", fieldName);
                    if (Loader.DEBUG) {
                        System.out.println(src);
                    }
                    staticinit.insertAfter(src);
                    continue block4;
                }
            }
            if (Loader.DEBUG) {
                System.out.println();
            }
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new PatchingException(e);
        }
    }
}

