/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.lib.SpireConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public abstract class UpdateChecker {
    protected static Map<String, SaveInfo> lastModified;
    protected URL jsonURL;
    protected JsonObject latest = null;

    public UpdateChecker(String jsonURL) throws MalformedURLException {
        this.jsonURL = new URL(jsonURL);
    }

    protected void obtainLatestRelease() throws IOException {
        if (lastModified == null) {
            String path = SpireConfig.makeFilePath(null, "Updater", "json");
            if (new File(path).isFile()) {
                String data = new String(Files.readAllBytes(Paths.get(path, new String[0])));
                Gson gson = new Gson();
                Type type = new TypeToken<Map<String, SaveInfo>>(){}.getType();
                lastModified = (Map)gson.fromJson(data, type);
            } else {
                lastModified = new HashMap<String, SaveInfo>();
            }
        }
        if (this.latest != null) {
            return;
        }
        HttpURLConnection request = (HttpURLConnection)this.jsonURL.openConnection();
        String urlString = this.jsonURL.toString();
        if (lastModified.containsKey(urlString)) {
            request.setRequestProperty("If-Modified-Since", UpdateChecker.lastModified.get((Object)urlString).lastModified);
        }
        request.connect();
        if (request.getResponseCode() == 304) {
            this.latest = UpdateChecker.lastModified.get((Object)urlString).releaseInfo;
            return;
        }
        System.out.println(request.getHeaderField("Last-Modified"));
        try {
            JsonParser jp = new JsonParser();
            JsonElement root = jp.parse(new InputStreamReader((InputStream)request.getContent()));
            this.latest = root.getAsJsonObject();
            SaveInfo saveInfo = new SaveInfo();
            saveInfo.lastModified = request.getHeaderField("Last-Modified");
            saveInfo.releaseInfo = this.latest;
            lastModified.put(urlString, saveInfo);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String data = gson.toJson(lastModified);
            Files.write(Paths.get(SpireConfig.makeFilePath(null, "Updater", "json"), new String[0]), data.getBytes(), new OpenOption[0]);
        }
        catch (JsonSyntaxException e) {
            System.out.println(this.jsonURL);
            System.out.println(e.getMessage());
        }
    }

    public boolean isNewerVersionAvailable(Semver current) throws IOException {
        this.obtainLatestRelease();
        if (this.latest == null) {
            return false;
        }
        Semver latestVersion = this.getLatestReleaseVersion();
        if (latestVersion != null) {
            return latestVersion.compareTo(current) > 0;
        }
        return false;
    }

    public JsonElement getElement(String key) throws IOException {
        this.obtainLatestRelease();
        if (this.latest == null) {
            return null;
        }
        return this.latest.get(key);
    }

    public String getElementAsString(String key) throws IOException {
        JsonElement element = this.getElement(key);
        if (element == null) {
            return null;
        }
        return this.getElement(key).getAsString();
    }

    public abstract Semver getLatestReleaseVersion() throws IOException;

    public abstract URL getLatestReleaseURL() throws IOException;

    public abstract URL getLatestDownloadURL() throws IOException;

    private class SaveInfo {
        public String lastModified;
        public JsonObject releaseInfo;

        private SaveInfo() {
        }
    }
}

