/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

class OutJar {
    OutJar() {
    }

    private static Iterator<Class<?>> getClassList(ClassLoader CL) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> CL_class;
        for (CL_class = CL.getClass(); CL_class != ClassLoader.class; CL_class = CL_class.getSuperclass()) {
        }
        Field ClassLoader_classes_field = CL_class.getDeclaredField("classes");
        ClassLoader_classes_field.setAccessible(true);
        Vector classes = (Vector)ClassLoader_classes_field.get(CL);
        return classes.iterator();
    }

    public static void dumpJar(ClassLoader loader, ClassPool pool, String jarPath) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException {
        Iterator<Class<?>> loadedClasses = OutJar.getClassList(loader);
        ArrayList<FilePathAndBytes> files = new ArrayList<FilePathAndBytes>();
        while (loadedClasses.hasNext()) {
            try {
                String className = loadedClasses.next().getName();
                CtClass ctClass = pool.get(className);
                byte[] b = ctClass.toBytecode();
                String classPath = className.replaceAll("\\.", "/") + ".class";
                files.add(new FilePathAndBytes(classPath, b));
            }
            catch (IOException | CannotCompileException | NotFoundException className) {}
        }
        JarHandler handler = new JarHandler();
        handler.writeOut(jarPath, files);
    }

    public static class JarHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeOut(String jarPathAndName, List<FilePathAndBytes> files) throws IOException {
            File jarFile = new File(jarPathAndName);
            try (JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(jarFile));){
                try {
                    for (FilePathAndBytes file : files) {
                        String fileName = file.path;
                        byte[] fileByteCode = file.b;
                        JarEntry entry = new JarEntry(fileName);
                        tempJar.putNextEntry(entry);
                        tempJar.write(fileByteCode);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    tempJar.putNextEntry(new JarEntry("stub"));
                }
            }
        }
    }

    public static class FilePathAndBytes {
        public String path;
        public byte[] b;

        public FilePathAndBytes(String path, byte[] b) {
            this.path = path;
            this.b = b;
        }
    }
}

