/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.lib.ConfigUtils;
import com.evacipated.cardcrawl.modthespire.ui.JModPanelCheckBoxList;
import com.evacipated.cardcrawl.modthespire.ui.ModPanel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModList {
    private static String OLD_CFG_FILE = ConfigUtils.CONFIG_DIR + File.separator + "mod_order.xml";
    private static String CFG_FILE = ConfigUtils.CONFIG_DIR + File.separator + "mod_lists.json";
    public static String DEFAULT_LIST = "<Default>";
    private static ModListSaveData saveData = null;
    private String name;
    private List<String> mods;

    public static String getDefaultList() {
        if (saveData == null) {
            return DEFAULT_LIST;
        }
        return ModList.saveData.defaultList;
    }

    public static Collection<String> getAllModListNames() {
        return ModList.saveData.lists.keySet();
    }

    public static ModList loadModLists() {
        File oldConfig = new File(OLD_CFG_FILE);
        if (oldConfig.exists()) {
            ModList.convertOldConfig(oldConfig);
        } else if (Files.exists(Paths.get(CFG_FILE, new String[0]), new LinkOption[0])) {
            try {
                String data = new String(Files.readAllBytes(Paths.get(CFG_FILE, new String[0])));
                Gson gson = new Gson();
                saveData = gson.fromJson(data, ModListSaveData.class);
            }
            catch (JsonSyntaxException e) {
                saveData = new ModListSaveData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            saveData = new ModListSaveData();
        }
        return new ModList(ModList.saveData.defaultList);
    }

    public static void convertOldConfig(File oldConfig) {
        try {
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(oldConfig));
            NodeList modsFromCfg = d.getElementsByTagName("mod");
            saveData = new ModListSaveData();
            ArrayList<String> mods = new ArrayList<String>();
            for (int i = 0; i < modsFromCfg.getLength(); ++i) {
                mods.add(modsFromCfg.item(i).getTextContent());
            }
            ModList.saveData.lists.put(DEFAULT_LIST, mods);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String data = gson.toJson(saveData);
            Files.write(Paths.get(CFG_FILE, new String[0]), data.getBytes(), new OpenOption[0]);
            oldConfig.delete();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public ModList(String list) {
        if (saveData == null) {
            ModList.loadModLists();
        }
        this.name = list;
        ModList.saveData.lists.putIfAbsent(this.name, Collections.emptyList());
        this.mods = ModList.saveData.lists.getOrDefault(this.name, Collections.emptyList());
    }

    public String getName() {
        return this.name;
    }

    public void loadModsInOrder(DefaultListModel<ModPanel> model, ModInfo[] info, JModPanelCheckBoxList parent) {
        int i;
        model.clear();
        File[] modFiles = new File[info.length];
        for (int i2 = 0; i2 < info.length; ++i2) {
            if (info[i2].jarURL == null) {
                System.out.println("ERROR: jarURL is null?: " + info[i2].Name);
                continue;
            }
            try {
                modFiles[i2] = new File(info[i2].jarURL.toURI());
                continue;
            }
            catch (URISyntaxException e) {
                System.out.println("Problem with: " + info[i2].jarURL);
                e.printStackTrace();
            }
        }
        ArrayList<ModDescriptor> loadOrder = new ArrayList<ModDescriptor>();
        ArrayList<Integer> foundMods = new ArrayList<Integer>();
        for (i = 0; i < this.mods.size(); ++i) {
            for (int j = 0; j < modFiles.length; ++j) {
                if (!this.mods.get(i).equals(modFiles[j].getName())) continue;
                loadOrder.add(new ModDescriptor(modFiles[j], info[j], true));
                foundMods.add(i);
            }
        }
        for (i = 0; i < this.mods.size(); ++i) {
            if (foundMods.contains(i)) continue;
            System.out.println("could not find mod: " + this.mods.get(i) + " even though it was specified in load order");
        }
        for (i = 0; i < modFiles.length; ++i) {
            boolean found = false;
            for (int j = 0; j < loadOrder.size(); ++j) {
                ModDescriptor descriptor = (ModDescriptor)loadOrder.get(j);
                if (descriptor.mod != modFiles[i] || descriptor.info != info[i]) continue;
                found = true;
            }
            if (found) continue;
            loadOrder.add(new ModDescriptor(modFiles[i], info[i], false));
        }
        for (ModDescriptor descriptor : loadOrder) {
            ModPanel toAdd = new ModPanel(descriptor.info, descriptor.mod, parent);
            if (toAdd.checkBox.isEnabled()) {
                toAdd.checkBox.setSelected(descriptor.checked);
            }
            model.addElement(toAdd);
        }
    }

    public static void save(String list, File[] modFiles) {
        ModList.saveData.defaultList = list;
        ArrayList<String> modList = new ArrayList<String>();
        for (File modFile : modFiles) {
            modList.add(modFile.getName());
        }
        ModList.saveData.lists.put(list, modList);
        ModList.save();
    }

    private static void save() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String data = gson.toJson(saveData);
            Files.write(Paths.get(CFG_FILE, new String[0]), data.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delete(String list) {
        ModList.saveData.defaultList = DEFAULT_LIST;
        ModList.saveData.lists.remove(list);
        ModList.save();
    }

    private static class ModDescriptor {
        public File mod;
        public ModInfo info;
        public boolean checked;

        public ModDescriptor(File mod, ModInfo info, boolean checked) {
            this.mod = mod;
            this.info = info;
            this.checked = checked;
        }
    }

    private static class ModListSaveData {
        public String defaultList = DEFAULT_LIST;
        public Map<String, List<String>> lists = new HashMap<String, List<String>>();

        private ModListSaveData() {
        }
    }
}

