/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;

public class ModInfo
implements Serializable {
    private static final long serialVersionUID = 7452562412479584982L;
    public transient URL jarURL;
    public transient String statusMsg = " ";
    public transient boolean isWorkshop = false;
    @SerializedName(value="modid")
    public String ID;
    @SerializedName(value="name")
    public String Name = "";
    @SerializedName(value="version")
    public Semver ModVersion;
    @SerializedName(value="author_list")
    public String[] Authors = new String[0];
    @SerializedName(value="credits")
    public String Credits;
    @SerializedName(value="description")
    public String Description = "";
    @SerializedName(value="mts_version")
    public Semver MTS_Version = ModInfo.safeVersion("0.0.0");
    @SerializedName(value="sts_version")
    public String STS_Version = null;
    @SerializedName(value="dependencies")
    public String[] Dependencies = new String[0];
    @SerializedName(value="optional_dependencies")
    public String[] OptionalDependencies = new String[0];
    @SerializedName(value="update_json")
    public String UpdateJSON = null;

    private ModInfo() {
    }

    public String getIDName() {
        if (this.ID == null || this.ID.isEmpty()) {
            return this.Name;
        }
        return this.ID;
    }

    private static void closeLoader(URLClassLoader loader) {
        try {
            if (loader != null) {
                loader.close();
            }
        }
        catch (Exception e) {
            System.out.println("Exception during loader.close(), URLClassLoader may be leaked. " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModInfo ReadModInfo(File mod_jar) {
        ModInfo modInfo;
        URLClassLoader loader;
        block9: {
            ModInfo modInfo2;
            block8: {
                Gson gson = new GsonBuilder().excludeFieldsWithModifiers(8, 128).registerTypeAdapter((Type)((Object)Semver.class), new VersionDeserializer()).setDateFormat("MM-dd-yyyy").create();
                loader = null;
                try {
                    loader = new URLClassLoader(new URL[]{mod_jar.toURI().toURL()}, null);
                    InputStream in = loader.getResourceAsStream("ModTheSpire.json");
                    if (in == null) {
                        ModInfo info = ModInfo.ReadModInfoOld(mod_jar);
                        info.jarURL = mod_jar.toURI().toURL();
                        modInfo2 = info;
                        if (loader == null) return modInfo2;
                        break block8;
                    }
                    ModInfo info = gson.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), ModInfo.class);
                    info.jarURL = mod_jar.toURI().toURL();
                    in.close();
                    modInfo = info;
                    if (loader == null) return modInfo;
                    break block9;
                }
                catch (Exception e) {
                    System.out.println(mod_jar);
                    e.printStackTrace();
                    return null;
                }
            }
            ModInfo.closeLoader(loader);
            return modInfo2;
        }
        ModInfo.closeLoader(loader);
        return modInfo;
        finally {
            if (loader != null) {
                ModInfo.closeLoader(loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModInfo ReadModInfoOld(File mod_jar) {
        URLClassLoader loader;
        ModInfo info;
        block5: {
            info = new ModInfo();
            info.Name = mod_jar.getName();
            info.Name = info.Name.substring(0, info.Name.length() - 4);
            loader = null;
            try {
                loader = new URLClassLoader(new URL[]{mod_jar.toURI().toURL()});
                Properties prop = new Properties();
                InputStream inProp = loader.getResourceAsStream("ModTheSpire.config");
                if (inProp == null) break block5;
                prop.load(new InputStreamReader(inProp, StandardCharsets.UTF_8));
                info.Name = prop.getProperty("name");
                String author = prop.getProperty("author");
                if (author != null && !author.isEmpty()) {
                    info.Authors = author.split(",");
                }
                info.MTS_Version = ModInfo.safeVersion(prop.getProperty("mts_version", "0.0.0"));
                info.Description = prop.getProperty("description");
                info.STS_Version = prop.getProperty("sts_version");
                inProp.close();
            }
            catch (Exception e) {
                try {
                    System.out.println("ERROR: Failed to read Mod info from " + mod_jar.getName());
                }
                catch (Throwable throwable) {
                    ModInfo.closeLoader(loader);
                    throw throwable;
                }
                ModInfo.closeLoader(loader);
            }
        }
        ModInfo.closeLoader(loader);
        return info;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModInfo)) {
            return false;
        }
        ModInfo info = (ModInfo)obj;
        if (this.ID == null && info.ID == null) {
            return Objects.equals(this.Name, info.Name);
        }
        return Objects.equals(this.ID, info.ID);
    }

    public int hashCode() {
        return Objects.hash(this.ID, this.Name);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.ID);
        out.writeObject(this.Name);
        out.writeObject(this.ModVersion.toString());
        out.writeObject(this.Authors);
        out.writeObject(this.Credits);
        out.writeObject(this.Description);
        out.writeObject(this.MTS_Version.toString());
        out.writeObject(this.STS_Version);
        out.writeObject(this.Dependencies);
        out.writeObject(this.OptionalDependencies);
        out.writeObject(this.UpdateJSON);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.ID = (String)in.readObject();
        this.Name = (String)in.readObject();
        this.ModVersion = ModInfo.safeVersion((String)in.readObject());
        this.Authors = (String[])in.readObject();
        this.Credits = (String)in.readObject();
        this.Description = (String)in.readObject();
        this.MTS_Version = ModInfo.safeVersion((String)in.readObject());
        this.STS_Version = (String)in.readObject();
        this.Dependencies = (String[])in.readObject();
        this.OptionalDependencies = (String[])in.readObject();
        this.UpdateJSON = (String)in.readObject();
    }

    public static Semver safeVersion(String verString) {
        return new Semver(verString, Semver.SemverType.NPM);
    }

    private static class VersionDeserializer
    implements JsonDeserializer<Semver> {
        private VersionDeserializer() {
        }

        @Override
        public Semver deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                return ModInfo.safeVersion(jsonElement.getAsJsonPrimitive().getAsString());
            }
            catch (SemverException e) {
                return null;
            }
        }
    }
}

