/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.CyclicDependencyException;
import com.evacipated.cardcrawl.modthespire.DuplicateModIDException;
import com.evacipated.cardcrawl.modthespire.GameBetaFinder;
import com.evacipated.cardcrawl.modthespire.GameVersionFinder;
import com.evacipated.cardcrawl.modthespire.GraphTS;
import com.evacipated.cardcrawl.modthespire.MTSClassLoader;
import com.evacipated.cardcrawl.modthespire.MTSClassPool;
import com.evacipated.cardcrawl.modthespire.MissingDependencyException;
import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.OutJar;
import com.evacipated.cardcrawl.modthespire.Patcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireConfig;
import com.evacipated.cardcrawl.modthespire.steam.SteamSearch;
import com.evacipated.cardcrawl.modthespire.steam.SteamWorkshop;
import com.evacipated.cardcrawl.modthespire.ui.ModSelectWindow;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.vdurmont.semver4j.Semver;
import java.awt.EventQueue;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.swing.JOptionPane;
import org.shaded.objectweb.asm.ClassReader;

public class Loader {
    public static boolean DEBUG = false;
    public static boolean OUT_JAR = false;
    public static Semver MTS_VERSION;
    public static String MOD_DIR;
    public static String STS_JAR;
    private static String MAC_STS_JAR;
    private static String STS_JAR2;
    public static String COREPATCHES_JAR;
    public static String STS_PATCHED_JAR;
    public static String JRE_51_DIR;
    public static ModInfo[] MODINFOS;
    private static ClassPool POOL;
    public static SpireConfig MTS_CONFIG;
    public static String STS_VERSION;
    public static boolean STS_BETA;
    public static boolean allowBeta;
    static String[] ARGS;
    private static ModSelectWindow ex;

    public static boolean isModLoaded(String modID) {
        for (int i = 0; i < MODINFOS.length; ++i) {
            if (!modID.equals(Loader.MODINFOS[i].ID)) continue;
            return true;
        }
        return false;
    }

    public static ClassPool getClassPool() {
        return POOL;
    }

    public static void main(String[] args) {
        ProcessBuilder pb;
        if (!Arrays.asList(args).contains("--jre51") && new File(JRE_51_DIR).exists()) {
            System.out.println("JRE 51 exists, restarting using it...");
            try {
                String path = Loader.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                path = URLDecoder.decode(path, "utf-8");
                path = new File(path).getPath();
                String[] newArgs = new String[args.length + 4];
                newArgs[0] = SteamSearch.findJRE51();
                newArgs[1] = "-jar";
                newArgs[2] = path;
                newArgs[3] = "--jre51";
                System.arraycopy(args, 0, newArgs, 4, args.length);
                pb = new ProcessBuilder(newArgs);
                pb.redirectOutput(new File("sendToDevs", "mts_process_launch.log"));
                pb.redirectErrorStream(true);
                pb.start();
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(3);
            }
        } else if (Arrays.asList(args).contains("--jre51")) {
            System.out.println("Launched using JRE 51");
        }
        ARGS = args;
        try {
            Properties defaults = new Properties();
            defaults.setProperty("debug", Boolean.toString(false));
            defaults.setProperty("out-jar", Boolean.toString(false));
            defaults.putAll((Map<?, ?>)ModSelectWindow.getDefaults());
            MTS_CONFIG = new SpireConfig(null, "ModTheSpire", defaults);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEBUG = MTS_CONFIG.getBool("debug");
        OUT_JAR = MTS_CONFIG.getBool("out-jar");
        if (Arrays.asList(args).contains("--debug")) {
            DEBUG = true;
        }
        if (Arrays.asList(args).contains("--out-jar")) {
            OUT_JAR = true;
        }
        allowBeta = true;
        if (Arrays.asList(args).contains("--allow-beta")) {
            allowBeta = true;
        }
        try {
            Properties properties = new Properties();
            properties.load(Loader.class.getResourceAsStream("/META-INF/version.prop"));
            MTS_VERSION = ModInfo.safeVersion(properties.getProperty("version"));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            String thisJarName = new File(Loader.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getName();
            if (thisJarName.equals(STS_JAR)) {
                STS_JAR = STS_JAR2;
            }
        }
        catch (URISyntaxException thisJarName) {
            // empty catch block
        }
        File tmp = new File(STS_JAR);
        if (!tmp.exists()) {
            String steamJar = SteamSearch.findDesktopJar();
            if (steamJar != null && new File(steamJar).exists()) {
                STS_JAR = steamJar;
            } else {
                tmp = new File(MAC_STS_JAR);
                Loader.checkFileInfo(tmp);
                if (!tmp.exists()) {
                    Loader.checkFileInfo(new File("SlayTheSpire.app"));
                    Loader.checkFileInfo(new File("SlayTheSpire.app/Contents"));
                    Loader.checkFileInfo(new File("SlayTheSpire.app/Contents/Resources"));
                    JOptionPane.showMessageDialog(null, "Unable to find '" + STS_JAR + "'");
                    return;
                }
                System.out.println("Using Mac version at: " + MAC_STS_JAR);
                STS_JAR = MAC_STS_JAR;
            }
        }
        ArrayList<SteamSearch.WorkshopInfo> workshopInfos = new ArrayList<SteamSearch.WorkshopInfo>();
        try {
            System.out.println("Searching for Workshop items...");
            String path = SteamWorkshop.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = URLDecoder.decode(path, "utf-8");
            path = new File(path).getPath();
            pb = new ProcessBuilder(SteamSearch.findJRE(), "-cp", path + File.pathSeparatorChar + STS_JAR, "com.evacipated.cardcrawl.modthespire.steam.SteamWorkshop").redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String title = null;
            String id = null;
            String installPath = null;
            String timeUpdated = null;
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                if (title == null) {
                    title = line;
                    continue;
                }
                if (id == null) {
                    id = line;
                    continue;
                }
                if (installPath == null) {
                    installPath = line;
                    continue;
                }
                if (timeUpdated == null) {
                    timeUpdated = line;
                    continue;
                }
                SteamSearch.WorkshopInfo info = new SteamSearch.WorkshopInfo(title, id, installPath, timeUpdated, line);
                if (!info.hasTag("tool") && !info.hasTag("tools")) {
                    workshopInfos.add(info);
                }
                title = null;
                id = null;
                installPath = null;
                timeUpdated = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Got " + workshopInfos.size() + " workshop items");
        try {
            Map<String, Integer> lastUpdated = null;
            String path = SpireConfig.makeFilePath(null, "WorkshopUpdated", "json");
            if (new File(path).isFile()) {
                String data = new String(Files.readAllBytes(Paths.get(path, new String[0])));
                Gson gson = new Gson();
                Type type = new TypeToken<Map<String, Integer>>(){}.getType();
                try {
                    lastUpdated = (Map)gson.fromJson(data, type);
                }
                catch (JsonSyntaxException ignore) {
                    lastUpdated = null;
                }
            }
            if (lastUpdated == null) {
                lastUpdated = new HashMap();
            }
            for (SteamSearch.WorkshopInfo info : workshopInfos) {
                int savedTime;
                if (info == null || (savedTime = lastUpdated.getOrDefault(info.getID(), 0).intValue()) >= info.getTimeUpdated()) continue;
                lastUpdated.put(info.getID(), info.getTimeUpdated());
                if (savedTime == 0) continue;
                System.out.println(info.getTitle() + " WAS UPDATED!");
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String data = gson.toJson(lastUpdated);
            Files.write(Paths.get(SpireConfig.makeFilePath(null, "WorkshopUpdated", "json"), new String[0]), data.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Loader.findGameVersion();
        EventQueue.invokeLater(() -> {
            ModInfo[] modInfos = Loader.getAllMods(workshopInfos);
            ex = new ModSelectWindow(modInfos);
            ex.setVisible(true);
            ex.warnAboutMissingVersions();
            String java_version = System.getProperty("java.version");
            if (!java_version.startsWith("1.8")) {
                String msg = "ModTheSpire requires Java version 8 to run properly.\nYou are currently using Java " + java_version;
                JOptionPane.showMessageDialog(null, msg, "Warning", 2);
            }
            ex.startCheckingForMTSUpdate();
        });
    }

    public static void closeWindow() {
        ex.dispatchEvent(new WindowEvent(ex, 201));
    }

    public static void runMods(File[] modJars) {
        if (DEBUG) {
            System.out.println("Running with debug mode turned ON...");
            System.out.println();
        }
        try {
            ModInfo[] modInfos = Loader.buildInfoArray(modJars);
            Loader.checkDependencies(modInfos);
            modInfos = Loader.orderDependencies(modInfos);
            MODINFOS = modInfos;
            Loader.printMTSInfo();
            MTSClassLoader loader = new MTSClassLoader(Loader.class.getResourceAsStream(COREPATCHES_JAR), Loader.buildUrlArray(modInfos), Loader.class.getClassLoader());
            if (modJars.length > 0) {
                MTSClassLoader tmpPatchingLoader = new MTSClassLoader(Loader.class.getResourceAsStream(COREPATCHES_JAR), Loader.buildUrlArray(modInfos), Loader.class.getClassLoader());
                System.out.println("Begin patching...");
                MTSClassPool pool = new MTSClassPool(tmpPatchingLoader);
                pool.insertClassPath(new LoaderClassPath(tmpPatchingLoader));
                tmpPatchingLoader.addStreamToClassPool(pool);
                TreeMap<String, CtClass> ctClasses = new TreeMap<String, CtClass>();
                System.out.printf("Patching enums...", new Object[0]);
                for (CtClass cls : Patcher.patchEnums((ClassLoader)tmpPatchingLoader, (ClassPool)pool, Loader.class.getResource(COREPATCHES_JAR))) {
                    ctClasses.put(Loader.countSuperClasses(cls) + cls.getName(), cls);
                }
                for (CtClass cls : Patcher.patchEnums((ClassLoader)tmpPatchingLoader, (ClassPool)pool, modInfos)) {
                    ctClasses.put(Loader.countSuperClasses(cls) + cls.getName(), cls);
                }
                System.out.println("Done.");
                System.out.println("Finding core patches...");
                for (CtClass cls : Patcher.injectPatches((ClassLoader)tmpPatchingLoader, (ClassPool)pool, Patcher.findPatches(new URL[]{Loader.class.getResource(COREPATCHES_JAR)}))) {
                    ctClasses.put(Loader.countSuperClasses(cls) + cls.getName(), cls);
                }
                System.out.println("Finding patches...");
                for (CtClass cls : Patcher.injectPatches((ClassLoader)tmpPatchingLoader, (ClassPool)pool, Patcher.findPatches(MODINFOS))) {
                    ctClasses.put(Loader.countSuperClasses(cls) + cls.getName(), cls);
                }
                for (CtClass cls : Patcher.patchOverrides(tmpPatchingLoader, pool, MODINFOS)) {
                    ctClasses.put(Loader.countSuperClasses(cls) + cls.getName(), cls);
                }
                Patcher.finalizePatches(tmpPatchingLoader);
                Patcher.compilePatches(loader, ctClasses);
                ctClasses.clear();
                tmpPatchingLoader.close();
                POOL = new MTSClassPool(loader);
                POOL.insertClassPath(new LoaderClassPath(loader));
                loader.addStreamToClassPool(POOL);
                ((MTSClassPool)POOL).setParent(pool);
                Loader.POOL.childFirstLookup = true;
                System.out.printf("Busting enums...", new Object[0]);
                Patcher.bustEnums((ClassLoader)loader, Loader.class.getResource(COREPATCHES_JAR));
                Patcher.bustEnums((ClassLoader)loader, modInfos);
                System.out.println("Done.");
                System.out.println();
                System.out.printf("Setting isModded = true...", new Object[0]);
                System.out.flush();
                Class<?> Settings = loader.loadClass("com.megacrit.cardcrawl.core.Settings");
                Field isModded = Settings.getDeclaredField("isModded");
                isModded.set(null, true);
                System.out.println("Done.");
                System.out.println();
                Field isDev = Settings.getDeclaredField("isDev");
                isDev.set(null, false);
                System.out.printf("Adding ModTheSpire to version...", new Object[0]);
                System.out.flush();
                Class<?> CardCrawlGame = loader.loadClass("com.megacrit.cardcrawl.core.CardCrawlGame");
                Field VERSION_NUM = CardCrawlGame.getDeclaredField("VERSION_NUM");
                String oldVersion = (String)VERSION_NUM.get(null);
                VERSION_NUM.set(null, oldVersion + " [ModTheSpire " + MTS_VERSION + "]");
                System.out.println("Done.");
                System.out.println();
                if (OUT_JAR) {
                    System.out.printf("Dumping JAR...", new Object[0]);
                    OutJar.dumpJar(loader, pool, STS_PATCHED_JAR);
                    System.out.println("Done.");
                    return;
                }
                System.out.println("Initializing mods...");
                Patcher.initializeMods(loader, modInfos);
                System.out.println("Done.");
                System.out.println();
            }
            System.out.println("Starting game...");
            Class<?> cls = loader.loadClass("com.megacrit.cardcrawl.desktop.DesktopLauncher");
            Method method = cls.getDeclaredMethod("main", String[].class);
            method.invoke(null, new Object[]{ARGS});
            if (!DEBUG) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ex.setState(1);
                    }
                }, 1000L);
            }
        }
        catch (MissingDependencyException e) {
            System.err.println("ERROR: " + e.getMessage());
            JOptionPane.showMessageDialog(null, e.getMessage(), "Missing Dependency", 0);
        }
        catch (DuplicateModIDException e) {
            System.err.println("ERROR: " + e.getMessage());
            JOptionPane.showMessageDialog(null, e.getMessage(), "Duplicate Mod ID", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setGameVersion(String versionString) {
        if (versionString.startsWith("(") && versionString.endsWith(")")) {
            versionString = versionString.substring(1, versionString.length() - 1);
        }
        STS_VERSION = versionString;
    }

    private static void findGameVersion() {
        try {
            URLClassLoader tmpLoader = new URLClassLoader(new URL[]{new File(STS_JAR).toURI().toURL()});
            InputStream in = tmpLoader.getResourceAsStream("com/megacrit/cardcrawl/core/CardCrawlGame.class");
            ClassReader classReader = new ClassReader(in);
            classReader.accept(new GameVersionFinder(), 0);
            InputStream in2 = tmpLoader.getResourceAsStream("com/megacrit/cardcrawl/core/Settings.class");
            ClassReader classReader2 = new ClassReader(in2);
            classReader2.accept(new GameBetaFinder(), 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static URL[] buildUrlArray(ModInfo[] modInfos) throws MalformedURLException {
        URL[] urls = new URL[modInfos.length + 1];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        urls[modInfos.length] = new File(STS_JAR).toURI().toURL();
        return urls;
    }

    private static ModInfo[] buildInfoArray(File[] modJars) {
        ModInfo[] infos = new ModInfo[modJars.length];
        for (int i = 0; i < modJars.length; ++i) {
            infos[i] = ModInfo.ReadModInfo(modJars[i]);
        }
        return infos;
    }

    private static File[] getAllModFiles(String directory) {
        File file = new File(directory);
        if (!file.exists() || !file.isDirectory()) {
            return new File[0];
        }
        File[] files = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        if (files == null || files.length == 0) {
            return new File[0];
        }
        return files;
    }

    private static ModInfo[] getAllMods(List<SteamSearch.WorkshopInfo> workshopInfos) {
        ArrayList<ModInfo> modInfos = new ArrayList<ModInfo>();
        for (File f : Loader.getAllModFiles(MOD_DIR)) {
            ModInfo info = ModInfo.ReadModInfo(f);
            if (info == null || !modInfos.stream().noneMatch(i -> i.ID == null || i.ID.equals(info.ID))) continue;
            modInfos.add(info);
        }
        for (SteamSearch.WorkshopInfo workshopInfo : workshopInfos) {
            for (File f : Loader.getAllModFiles(workshopInfo.getInstallPath().toString())) {
                ModInfo info = ModInfo.ReadModInfo(f);
                if (info == null) continue;
                info.UpdateJSON = null;
                info.isWorkshop = true;
                boolean doAdd = true;
                Iterator it = modInfos.iterator();
                while (it.hasNext()) {
                    ModInfo modInfo = (ModInfo)it.next();
                    if (modInfo.ID == null || !modInfo.ID.equals(info.ID)) continue;
                    if (modInfo.ModVersion == null || info.ModVersion == null) {
                        doAdd = false;
                        break;
                    }
                    if (info.ModVersion.isGreaterThan(modInfo.ModVersion)) {
                        it.remove();
                        continue;
                    }
                    doAdd = false;
                    break;
                }
                if (!doAdd) continue;
                modInfos.add(info);
            }
        }
        modInfos.sort(Comparator.comparing(m -> m.Name));
        return modInfos.toArray(new ModInfo[0]);
    }

    private static void printMTSInfo() {
        System.out.println("ModVersion Info:");
        System.out.printf(" - Java version (%s)\n", System.getProperty("java.version"));
        System.out.printf(" - Slay the Spire (%s)", STS_VERSION);
        if (STS_BETA) {
            System.out.printf(" BETA", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
        System.out.printf(" - ModTheSpire (%s)\n", MTS_VERSION);
        System.out.printf("Mod list:\n", new Object[0]);
        for (ModInfo info : MODINFOS) {
            System.out.printf(" - %s", info.getIDName());
            if (info.ModVersion != null) {
                System.out.printf(" (%s)", info.ModVersion);
            }
            System.out.println();
        }
        System.out.println();
    }

    private static void checkDependencies(ModInfo[] modinfos) throws MissingDependencyException, DuplicateModIDException {
        HashMap<String, ModInfo> dependencyMap = new HashMap<String, ModInfo>();
        for (ModInfo info : modinfos) {
            if (info.ID == null) continue;
            if (!dependencyMap.containsKey(info.ID)) {
                dependencyMap.put(info.ID, info);
                continue;
            }
            throw new DuplicateModIDException((ModInfo)dependencyMap.get(info.ID), info);
        }
        for (ModInfo info : modinfos) {
            for (String dependency : info.Dependencies) {
                boolean has = false;
                for (ModInfo dependinfo : modinfos) {
                    if (dependinfo.ID == null || !dependinfo.ID.equals(dependency)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                throw new MissingDependencyException(info, dependency);
            }
        }
    }

    private static int findDependencyIndex(ModInfo[] modInfos, String dependencyID) {
        for (int i = 0; i < modInfos.length; ++i) {
            if (modInfos[i] == null || modInfos[i].ID == null || !modInfos[i].ID.equals(dependencyID)) continue;
            return i;
        }
        return -1;
    }

    private static ModInfo[] orderDependencies(ModInfo[] modInfos) throws CyclicDependencyException {
        GraphTS<ModInfo> g = new GraphTS<ModInfo>();
        for (ModInfo info : modInfos) {
            g.addVertex(info);
        }
        for (int i = 0; i < modInfos.length; ++i) {
            for (String dependency : modInfos[i].Dependencies) {
                g.addEdge(Loader.findDependencyIndex(modInfos, dependency), i);
            }
            for (String optionalDependency : modInfos[i].OptionalDependencies) {
                int idx = Loader.findDependencyIndex(modInfos, optionalDependency);
                if (idx == -1) continue;
                g.addEdge(idx, i);
            }
        }
        g.tsortStable();
        return g.sortedArray.toArray(new ModInfo[g.sortedArray.size()]);
    }

    private static void checkFileInfo(File file) {
        System.out.printf(file.getName() + ": ", new Object[0]);
        System.out.println(file.exists() ? "Exists" : "Does not exist");
        if (file.exists()) {
            System.out.printf("Type: ", new Object[0]);
            if (file.isFile()) {
                System.out.println("File");
            } else if (file.isDirectory()) {
                System.out.println("Directory");
                System.out.println("Contents:");
                for (File subfile : Objects.requireNonNull(file.listFiles())) {
                    System.out.println("  " + subfile.getName());
                }
            } else {
                System.out.println("Unknown");
            }
        }
    }

    private static int countSuperClasses(CtClass cls) {
        String name = cls.getName();
        int count = 0;
        while (cls != null) {
            try {
                cls = cls.getSuperclass();
            }
            catch (NotFoundException e) {
                break;
            }
            ++count;
        }
        return count;
    }

    static {
        MOD_DIR = "mods/";
        STS_JAR = "desktop-1.0.jar";
        MAC_STS_JAR = "SlayTheSpire.app/Contents/Resources/" + STS_JAR;
        STS_JAR2 = "SlayTheSpire.jar";
        COREPATCHES_JAR = "/corepatches.jar";
        STS_PATCHED_JAR = "desktop-1.0-patched.jar";
        JRE_51_DIR = "jre1.8.0_51";
        STS_VERSION = null;
        STS_BETA = false;
        allowBeta = false;
    }
}

