/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.clapper.util.classutil.AbstractClassFilter;
import org.clapper.util.classutil.AndClassFilter;
import org.clapper.util.classutil.ClassFinder;
import org.clapper.util.classutil.ClassInfo;
import org.clapper.util.classutil.FieldInfo;
import org.clapper.util.classutil.InterfaceOnlyClassFilter;
import org.clapper.util.classutil.NotClassFilter;
import org.clapper.util.classutil.RegexClassFilter;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ReflectionFactory;

public class EnumBusterReflect {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String VALUES_FIELD = "$VALUES";
    private static final String ORDINAL_FIELD = "ordinal";
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final ClassLoader loader;
    private final Class<?> clazz;
    private final Collection<Field> switchFields;
    private final Deque<Memento> undoStack = new LinkedList<Memento>();

    public EnumBusterReflect(ClassLoader loader, Class<?> clazz) throws NoSuchFieldException, ClassNotFoundException {
        this.loader = loader;
        this.clazz = clazz;
        this.switchFields = this.findRelatedSwitchFields();
    }

    public Enum<?> make(String value) {
        return this.make(value, 0, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public Enum<?> make(String value, int ordinal) {
        return this.make(value, ordinal, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public Enum<?> make(String value, int ordinal, Class[] additionalTypes, Object[] additional) {
        try {
            this.undoStack.push(new Memento());
            ConstructorAccessor ca = this.findConstructorAccessor(additionalTypes, this.clazz);
            return this.constructEnum(this.clazz, ca, value, ordinal, additional);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create enum", e);
        }
    }

    public void addByValue(Enum<?> e) {
        try {
            this.undoStack.push(new Memento());
            Field valuesField = this.findValuesField();
            Enum<?>[] values = this.values();
            for (int i = 0; i < values.length; ++i) {
                Enum<?> value = values[i];
                if (!value.name().equals(e.name())) continue;
                this.setOrdinal(e, value.ordinal());
                values[i] = e;
                this.replaceConstant(e);
                return;
            }
            Enum<?>[] newValues = Arrays.copyOf(values, values.length + 1);
            newValues[newValues.length - 1] = e;
            ReflectionHelper.setStaticFinalField(valuesField, newValues);
            int ordinal = newValues.length - 1;
            this.setOrdinal(e, ordinal);
            this.addSwitchCase();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not set the enum", ex);
        }
    }

    public boolean deleteByValue(Enum<?> e) {
        if (e == null) {
            throw new NullPointerException();
        }
        try {
            this.undoStack.push(new Memento());
            Enum<?>[] values = this.values();
            for (int i = 0; i < values.length; ++i) {
                Enum<?> value = values[i];
                if (!value.name().equals(e.name())) continue;
                Enum<?>[] newValues = Arrays.copyOf(values, values.length - 1);
                System.arraycopy(values, i + 1, newValues, i, values.length - i - 1);
                for (int j = i; j < newValues.length; ++j) {
                    this.setOrdinal(newValues[j], j);
                }
                Field valuesField = this.findValuesField();
                ReflectionHelper.setStaticFinalField(valuesField, newValues);
                this.removeSwitchCase(i);
                this.blankOutConstant(e);
                return true;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not set the enum", ex);
        }
        return false;
    }

    public void restore() {
        while (this.undo()) {
        }
    }

    public boolean undo() {
        try {
            Memento memento = this.undoStack.poll();
            if (memento == null) {
                return false;
            }
            memento.undo();
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not undo", e);
        }
    }

    private ConstructorAccessor findConstructorAccessor(Class[] additionalParameterTypes, Class<?> clazz) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        Constructor<?> cstr = clazz.getDeclaredConstructor(parameterTypes);
        return this.reflection.newConstructorAccessor(cstr);
    }

    private Enum<?> constructEnum(Class<?> clazz, ConstructorAccessor ca, String value, int ordinal, Object[] additional) throws Exception {
        Object[] parms = new Object[additional.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additional, 0, parms, 2, additional.length);
        return (Enum)clazz.cast(ca.newInstance(parms));
    }

    private void addSwitchCase() {
        try {
            for (Field switchField : this.switchFields) {
                int[] switches = (int[])switchField.get(null);
                switches = Arrays.copyOf(switches, switches.length + 1);
                ReflectionHelper.setStaticFinalField(switchField, switches);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not fix switch", e);
        }
    }

    private void replaceConstant(Enum<?> e) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(e.name())) continue;
            ReflectionHelper.setStaticFinalField(field, e);
        }
    }

    private void blankOutConstant(Enum<?> e) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(e.name())) continue;
            ReflectionHelper.setStaticFinalField(field, null);
        }
    }

    private void setOrdinal(Enum<?> e, int ordinal) throws NoSuchFieldException, IllegalAccessException {
        Field ordinalField = Enum.class.getDeclaredField(ORDINAL_FIELD);
        ordinalField.setAccessible(true);
        ordinalField.set(e, ordinal);
    }

    private Field findValuesField() throws NoSuchFieldException {
        Field valuesField = this.clazz.getDeclaredField(VALUES_FIELD);
        valuesField.setAccessible(true);
        return valuesField;
    }

    private Collection<Field> findRelatedSwitchFields() throws ClassNotFoundException, NoSuchFieldException {
        ArrayList<Field> result = new ArrayList<Field>();
        ClassFinder finder = new ClassFinder();
        finder.add(new File(Loader.STS_JAR));
        AndClassFilter filter = new AndClassFilter(new NotClassFilter(new InterfaceOnlyClassFilter()), new NotClassFilter(new AbstractClassFilter()), new RegexClassFilter("com\\.megacrit\\.cardcrawl\\..+\\$1"));
        ArrayList<ClassInfo> foundClasses = new ArrayList<ClassInfo>();
        finder.findClasses(foundClasses, filter);
        if (Loader.DEBUG) {
            System.out.println();
            System.out.println(this.clazz.getName());
        }
        int count = 0;
        for (ClassInfo classInfo : foundClasses) {
            for (FieldInfo field : classInfo.getFields()) {
                String switchMapName = "$SwitchMap$" + this.clazz.getName().replace('.', '$');
                if (!field.getName().equals(switchMapName)) continue;
                ++count;
                if (Loader.DEBUG) {
                    System.out.println("  " + classInfo.getClassName());
                }
                Field realField = this.loader.loadClass(classInfo.getClassName()).getDeclaredField(field.getName());
                realField.setAccessible(true);
                result.add(realField);
            }
        }
        if (Loader.DEBUG) {
            System.out.println(count + " switch statement(s)");
        }
        return result;
    }

    private void removeSwitchCase(int ordinal) {
        try {
            for (Field switchField : this.switchFields) {
                int[] switches = (int[])switchField.get(null);
                int[] newSwitches = Arrays.copyOf(switches, switches.length - 1);
                System.arraycopy(switches, ordinal + 1, newSwitches, ordinal, switches.length - ordinal - 1);
                ReflectionHelper.setStaticFinalField(switchField, newSwitches);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not fix switch", e);
        }
    }

    private Enum<?>[] values() throws NoSuchFieldException, IllegalAccessException {
        Field valuesField = this.findValuesField();
        return (Enum[])valuesField.get(null);
    }

    private class Memento {
        private final Enum<?>[] values;
        private final Map<Field, int[]> savedSwitchFieldValues = new HashMap<Field, int[]>();

        private Memento() throws IllegalAccessException {
            try {
                this.values = (Enum[])EnumBusterReflect.this.values().clone();
                for (Field switchField : EnumBusterReflect.this.switchFields) {
                    int[] switchArray = (int[])switchField.get(null);
                    this.savedSwitchFieldValues.put(switchField, (int[])switchArray.clone());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create the class", e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void undo() throws NoSuchFieldException, IllegalAccessException {
            void var5_8;
            Field valuesField = EnumBusterReflect.this.findValuesField();
            ReflectionHelper.setStaticFinalField(valuesField, this.values);
            for (int i = 0; i < this.values.length; ++i) {
                EnumBusterReflect.this.setOrdinal(this.values[i], i);
            }
            HashMap valuesMap = new HashMap();
            Enum<?>[] enumArray = this.values;
            int n = enumArray.length;
            boolean bl = false;
            while (var5_8 < n) {
                Enum<?> e = enumArray[var5_8];
                valuesMap.put(e.name(), e);
                ++var5_8;
            }
            Field[] constantEnumFields = EnumBusterReflect.this.clazz.getDeclaredFields();
            for (Field constantEnumField : constantEnumFields) {
                Enum en = (Enum)valuesMap.get(constantEnumField.getName());
                if (en == null) continue;
                ReflectionHelper.setStaticFinalField(constantEnumField, en);
            }
            for (Map.Entry entry : this.savedSwitchFieldValues.entrySet()) {
                Field field = (Field)entry.getKey();
                int[] mappings = (int[])entry.getValue();
                ReflectionHelper.setStaticFinalField(field, mappings);
            }
        }
    }
}

