/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Animation;
import com.brashmonkey.spriter.Box;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.FileReference;
import com.brashmonkey.spriter.Mainline;
import com.brashmonkey.spriter.Point;
import com.brashmonkey.spriter.Rectangle;
import com.brashmonkey.spriter.SpriterException;
import com.brashmonkey.spriter.Timeline;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Player {
    protected Entity entity;
    Animation animation;
    int time;
    public int speed = 15;
    Timeline.Key[] tweenedKeys;
    Timeline.Key[] unmappedTweenedKeys;
    private Timeline.Key[] tempTweenedKeys;
    private Timeline.Key[] tempUnmappedTweenedKeys;
    private List<PlayerListener> listeners;
    public final List<Attachment> attachments = new ArrayList<Attachment>();
    Timeline.Key.Bone root = new Timeline.Key.Bone(new Point(0.0f, 0.0f));
    private final Point position = new Point(0.0f, 0.0f);
    private final Point pivot = new Point(0.0f, 0.0f);
    private final HashMap<Timeline.Key.Object, Timeline.Key> objToTimeline = new HashMap();
    private float angle;
    private boolean dirty = true;
    public Entity.CharacterMap characterMap;
    private Rectangle rect;
    public final Box prevBBox;
    private BoneIterator boneIterator = new BoneIterator();
    private ObjectIterator objectIterator = new ObjectIterator();
    private Mainline.Key currentKey;
    private Mainline.Key prevKey;
    public boolean copyObjects = true;

    public Player(Entity entity) {
        this.rect = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        this.prevBBox = new Box();
        this.listeners = new ArrayList<PlayerListener>();
        this.setEntity(entity);
    }

    public void update() {
        for (PlayerListener listener : this.listeners) {
            listener.preProcess(this);
        }
        if (this.dirty) {
            this.updateRoot();
        }
        this.animation.update(this.time, this.root);
        this.currentKey = this.animation.currentKey;
        if (this.prevKey != this.currentKey) {
            for (PlayerListener listener : this.listeners) {
                listener.mainlineKeyChanged(this.prevKey, this.currentKey);
            }
            this.prevKey = this.currentKey;
        }
        if (this.copyObjects) {
            this.tweenedKeys = this.tempTweenedKeys;
            this.unmappedTweenedKeys = this.tempUnmappedTweenedKeys;
            this.copyObjects();
        } else {
            this.tweenedKeys = this.animation.tweenedKeys;
            this.unmappedTweenedKeys = this.animation.unmappedTweenedKeys;
        }
        for (Attachment attach : this.attachments) {
            attach.update();
        }
        for (PlayerListener listener : this.listeners) {
            listener.postProcess(this);
        }
        this.increaseTime();
    }

    private void copyObjects() {
        for (int i = 0; i < this.animation.tweenedKeys.length; ++i) {
            this.tweenedKeys[i].active = this.animation.tweenedKeys[i].active;
            this.unmappedTweenedKeys[i].active = this.animation.unmappedTweenedKeys[i].active;
            this.tweenedKeys[i].object().set(this.animation.tweenedKeys[i].object());
            this.unmappedTweenedKeys[i].object().set(this.animation.unmappedTweenedKeys[i].object());
        }
    }

    private void increaseTime() {
        this.time += this.speed;
        if (this.time > this.animation.length) {
            this.time -= this.animation.length;
            for (PlayerListener listener : this.listeners) {
                listener.animationFinished(this.animation);
            }
        }
        if (this.time < 0) {
            for (PlayerListener listener : this.listeners) {
                listener.animationFinished(this.animation);
            }
            this.time += this.animation.length;
        }
    }

    private void updateRoot() {
        this.root.angle = this.angle;
        this.root.position.set(this.pivot);
        this.root.position.rotate(this.angle);
        this.root.position.translate(this.position);
        this.dirty = false;
    }

    public Timeline.Key.Bone getBone(int index) {
        return this.unmappedTweenedKeys[this.getCurrentKey().getBoneRef((int)index).timeline].object();
    }

    public Timeline.Key.Object getObject(int index) {
        return this.unmappedTweenedKeys[this.getCurrentKey().getObjectRef((int)index).timeline].object();
    }

    public int getBoneIndex(String name) {
        for (Mainline.Key.BoneRef ref : this.getCurrentKey().boneRefs) {
            if (!this.animation.getTimeline((int)ref.timeline).name.equals(name)) continue;
            return ref.id;
        }
        return -1;
    }

    public Timeline.Key.Bone getBone(String name) {
        return this.unmappedTweenedKeys[this.animation.getTimeline((String)name).id].object();
    }

    public Mainline.Key.BoneRef getBoneRef(Timeline.Key.Bone bone) {
        return this.getCurrentKey().getBoneRefTimeline(this.objToTimeline.get((Object)bone).id);
    }

    public int getObjectIndex(String name) {
        for (Mainline.Key.ObjectRef ref : this.getCurrentKey().objectRefs) {
            if (!this.animation.getTimeline((int)ref.timeline).name.equals(name)) continue;
            return ref.id;
        }
        return -1;
    }

    public Timeline.Key.Object getObject(String name) {
        return this.unmappedTweenedKeys[this.animation.getTimeline((String)name).id].object();
    }

    public Mainline.Key.ObjectRef getObjectRef(Timeline.Key.Object object) {
        return this.getCurrentKey().getObjectRefTimeline(this.objToTimeline.get((Object)object).id);
    }

    public String getNameFor(Timeline.Key.Bone boneOrObject) {
        return this.animation.getTimeline((int)this.objToTimeline.get((Object)boneOrObject).id).name;
    }

    public Entity.ObjectInfo getObjectInfoFor(Timeline.Key.Bone boneOrObject) {
        return this.animation.getTimeline((int)this.objToTimeline.get((Object)boneOrObject).id).objectInfo;
    }

    public Timeline.Key getKeyFor(Timeline.Key.Bone boneOrObject) {
        return this.objToTimeline.get(boneOrObject);
    }

    public Box getBox(Timeline.Key.Bone boneOrObject) {
        Entity.ObjectInfo info = this.getObjectInfoFor(boneOrObject);
        this.prevBBox.calcFor(boneOrObject, info);
        return this.prevBBox;
    }

    public boolean collidesFor(Timeline.Key.Bone boneOrObject, float x, float y) {
        Entity.ObjectInfo info = this.getObjectInfoFor(boneOrObject);
        this.prevBBox.calcFor(boneOrObject, info);
        return this.prevBBox.collides(boneOrObject, info, x, y);
    }

    public boolean collidesFor(Timeline.Key.Bone boneOrObject, Point point) {
        return this.collidesFor(boneOrObject, point.x, point.y);
    }

    public boolean collidesFor(Timeline.Key.Bone boneOrObject, Rectangle area) {
        Entity.ObjectInfo info = this.getObjectInfoFor(boneOrObject);
        this.prevBBox.calcFor(boneOrObject, info);
        return this.prevBBox.isInside(area);
    }

    public void setBone(String name, float x, float y, float angle, float scaleX, float scaleY) {
        int index = this.getBoneIndex(name);
        if (index == -1) {
            throw new SpriterException("No bone found of name \"" + name + "\"");
        }
        Mainline.Key.BoneRef ref = this.getCurrentKey().getBoneRef(index);
        Timeline.Key.Bone bone = this.getBone(index);
        bone.set(x, y, angle, scaleX, scaleY, 0.0f, 0.0f);
        this.unmapObjects(ref);
    }

    public void setBone(String name, Point position, float angle, Point scale) {
        this.setBone(name, position.x, position.y, angle, scale.x, scale.y);
    }

    public void setBone(String name, float x, float y, float angle) {
        Timeline.Key.Bone b = this.getBone(name);
        this.setBone(name, x, y, angle, b.scale.x, b.scale.y);
    }

    public void setBone(String name, Point position, float angle) {
        Timeline.Key.Bone b = this.getBone(name);
        this.setBone(name, position.x, position.y, angle, b.scale.x, b.scale.y);
    }

    public void setBone(String name, float x, float y) {
        Timeline.Key.Bone b = this.getBone(name);
        this.setBone(name, x, y, b.angle);
    }

    public void setBone(String name, Point position) {
        this.setBone(name, position.x, position.y);
    }

    public void setBone(String name, float angle) {
        Timeline.Key.Bone b = this.getBone(name);
        this.setBone(name, b.position.x, b.position.y, angle);
    }

    public void setBone(String name, Timeline.Key.Bone bone) {
        this.setBone(name, bone.position, bone.angle, bone.scale);
    }

    public void setObject(String name, float x, float y, float angle, float scaleX, float scaleY, float pivotX, float pivotY, float alpha, int folder, int file) {
        int index = this.getObjectIndex(name);
        if (index == -1) {
            throw new SpriterException("No object found for name \"" + name + "\"");
        }
        Mainline.Key.ObjectRef ref = this.getCurrentKey().getObjectRef(index);
        Timeline.Key.Object object = this.getObject(index);
        object.set(x, y, angle, scaleX, scaleY, pivotX, pivotY, alpha, folder, file);
        this.unmapObjects(ref);
    }

    public void setObject(String name, Point position, float angle, Point scale, Point pivot, float alpha, FileReference ref) {
        this.setObject(name, position.x, position.y, angle, scale.x, scale.y, pivot.x, pivot.y, alpha, ref.folder, ref.file);
    }

    public void setObject(String name, float x, float y, float angle, float scaleX, float scaleY) {
        Timeline.Key.Object b = this.getObject(name);
        this.setObject(name, x, y, angle, scaleX, scaleY, b.pivot.x, b.pivot.y, b.alpha, b.ref.folder, b.ref.file);
    }

    public void setObject(String name, float x, float y, float angle) {
        Timeline.Key.Object b = this.getObject(name);
        this.setObject(name, x, y, angle, b.scale.x, b.scale.y);
    }

    public void setObject(String name, Point position, float angle) {
        Timeline.Key.Object b = this.getObject(name);
        this.setObject(name, position.x, position.y, angle, b.scale.x, b.scale.y);
    }

    public void setObject(String name, float x, float y) {
        Timeline.Key.Object b = this.getObject(name);
        this.setObject(name, x, y, b.angle);
    }

    public void setObject(String name, Point position) {
        this.setObject(name, position.x, position.y);
    }

    public void setObject(String name, float angle) {
        Timeline.Key.Object b = this.getObject(name);
        this.setObject(name, b.position.x, b.position.y, angle);
    }

    public void setObject(String name, float alpha, int folder, int file) {
        Timeline.Key.Object b = this.getObject(name);
        this.setObject(name, b.position.x, b.position.y, b.angle, b.scale.x, b.scale.y, b.pivot.x, b.pivot.y, alpha, folder, file);
    }

    public void setObject(String name, Timeline.Key.Object object) {
        this.setObject(name, object.position, object.angle, object.scale, object.pivot, object.alpha, object.ref);
    }

    public void unmapObjects(Mainline.Key.BoneRef base) {
        Timeline.Key.Bone parent;
        int start = base == null ? -1 : base.id - 1;
        for (int i = start + 1; i < this.getCurrentKey().boneRefs.size(); ++i) {
            Mainline.Key.BoneRef boneRef = this.getCurrentKey().getBoneRef(i);
            if (boneRef.parent != base && base != null) continue;
            parent = boneRef.parent == null ? this.root : this.unmappedTweenedKeys[boneRef.parent.timeline].object();
            this.unmappedTweenedKeys[boneRef.timeline].object().set(this.tweenedKeys[boneRef.timeline].object());
            this.unmappedTweenedKeys[boneRef.timeline].object().unmap(parent);
            this.unmapObjects(boneRef);
        }
        for (Mainline.Key.ObjectRef objectRef : this.getCurrentKey().objectRefs) {
            if (objectRef.parent != base && base != null) continue;
            parent = objectRef.parent == null ? this.root : this.unmappedTweenedKeys[objectRef.parent.timeline].object();
            this.unmappedTweenedKeys[objectRef.timeline].object().set(this.tweenedKeys[objectRef.timeline].object());
            this.unmappedTweenedKeys[objectRef.timeline].object().unmap(parent);
        }
    }

    public void setEntity(Entity entity) {
        if (entity == null) {
            throw new SpriterException("entity can not be null!");
        }
        this.entity = entity;
        int maxAnims = entity.getAnimationWithMostTimelines().timelines();
        this.tweenedKeys = new Timeline.Key[maxAnims];
        this.unmappedTweenedKeys = new Timeline.Key[maxAnims];
        for (int i = 0; i < maxAnims; ++i) {
            Timeline.Key key = new Timeline.Key(i);
            Timeline.Key keyU = new Timeline.Key(i);
            key.setObject(new Timeline.Key.Object(new Point(0.0f, 0.0f)));
            keyU.setObject(new Timeline.Key.Object(new Point(0.0f, 0.0f)));
            this.tweenedKeys[i] = key;
            this.unmappedTweenedKeys[i] = keyU;
            this.objToTimeline.put(keyU.object(), keyU);
        }
        this.tempTweenedKeys = this.tweenedKeys;
        this.tempUnmappedTweenedKeys = this.unmappedTweenedKeys;
        this.setAnimation(entity.getAnimation(0));
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setAnimation(Animation animation) {
        Animation prevAnim = this.animation;
        if (animation == this.animation) {
            return;
        }
        if (animation == null) {
            throw new SpriterException("animation can not be null!");
        }
        if (!this.entity.containsAnimation(animation) && animation.id != -1) {
            throw new SpriterException("animation has to be in the same entity as the current set one!");
        }
        if (animation != this.animation) {
            this.time = 0;
        }
        this.animation = animation;
        int tempTime = this.time;
        this.time = 0;
        this.update();
        this.time = tempTime;
        for (PlayerListener listener : this.listeners) {
            listener.animationChanged(prevAnim, animation);
        }
    }

    public void setAnimation(String name) {
        this.setAnimation(this.entity.getAnimation(name));
    }

    public void setAnimation(int index) {
        this.setAnimation(this.entity.getAnimation(index));
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Rectangle getBoundingRectangle(Mainline.Key.BoneRef root) {
        Timeline.Key.Bone boneRoot = root == null ? this.root : this.unmappedTweenedKeys[root.timeline].object();
        this.rect.set(boneRoot.position.x, boneRoot.position.y, boneRoot.position.x, boneRoot.position.y);
        this.calcBoundingRectangle(root);
        this.rect.calculateSize();
        return this.rect;
    }

    public Rectangle getBoudingRectangle(Timeline.Key.Bone root) {
        return this.getBoundingRectangle(root == null ? null : this.getBoneRef(root));
    }

    private void calcBoundingRectangle(Mainline.Key.BoneRef root) {
        Timeline.Key.Object bone;
        for (Mainline.Key.BoneRef boneRef : this.getCurrentKey().boneRefs) {
            if (boneRef.parent != root && root != null) continue;
            bone = this.unmappedTweenedKeys[boneRef.timeline].object();
            this.prevBBox.calcFor(bone, this.animation.getTimeline((int)boneRef.timeline).objectInfo);
            Rectangle.setBiggerRectangle(this.rect, this.prevBBox.getBoundingRect(), this.rect);
            this.calcBoundingRectangle(boneRef);
        }
        for (Mainline.Key.ObjectRef objectRef : this.getCurrentKey().objectRefs) {
            if (objectRef.parent != root) continue;
            bone = this.unmappedTweenedKeys[objectRef.timeline].object();
            this.prevBBox.calcFor(bone, this.animation.getTimeline((int)objectRef.timeline).objectInfo);
            Rectangle.setBiggerRectangle(this.rect, this.prevBBox.getBoundingRect(), this.rect);
        }
    }

    public Mainline.Key getCurrentKey() {
        return this.currentKey;
    }

    public int getTime() {
        return this.time;
    }

    public Player setTime(int time) {
        this.time = time;
        int prevSpeed = this.speed;
        this.speed = 0;
        this.increaseTime();
        this.speed = prevSpeed;
        return this;
    }

    public Player setScale(float scale) {
        this.root.scale.set(scale * (float)this.flippedX(), scale * (float)this.flippedY());
        return this;
    }

    public Player scale(float scale) {
        this.root.scale.scale(scale, scale);
        return this;
    }

    public float getScale() {
        return this.root.scale.x;
    }

    public Player flip(boolean x, boolean y) {
        if (x) {
            this.flipX();
        }
        if (y) {
            this.flipY();
        }
        return this;
    }

    public Player flipX() {
        this.root.scale.x *= -1.0f;
        return this;
    }

    public Player flipY() {
        this.root.scale.y *= -1.0f;
        return this;
    }

    public int flippedX() {
        return (int)Math.signum(this.root.scale.x);
    }

    public int flippedY() {
        return (int)Math.signum(this.root.scale.y);
    }

    public Player setPosition(float x, float y) {
        this.dirty = true;
        this.position.set(x, y);
        return this;
    }

    public Player setPosition(Point position) {
        return this.setPosition(position.x, position.y);
    }

    public Player translatePosition(float x, float y) {
        return this.setPosition(this.position.x + x, this.position.y + y);
    }

    public Player translate(Point amount) {
        return this.translatePosition(amount.x, amount.y);
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public Player setAngle(float angle) {
        this.dirty = true;
        this.angle = angle;
        return this;
    }

    public Player rotate(float angle) {
        return this.setAngle(angle + this.angle);
    }

    public float getAngle() {
        return this.angle;
    }

    public Player setPivot(float x, float y) {
        this.dirty = true;
        this.pivot.set(x, y);
        return this;
    }

    public Player setPivot(Point pivot) {
        return this.setPivot(pivot.x, pivot.y);
    }

    public Player translatePivot(float x, float y) {
        return this.setPivot(this.pivot.x + x, this.pivot.y + y);
    }

    public Player translatePivot(Point amount) {
        return this.translatePivot(amount.x, amount.y);
    }

    public float getPivotX() {
        return this.pivot.x;
    }

    public float getPivotY() {
        return this.pivot.y;
    }

    public void addListener(PlayerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PlayerListener listener) {
        this.listeners.remove(listener);
    }

    public Iterator<Timeline.Key.Bone> boneIterator() {
        return this.boneIterator(this.getCurrentKey().boneRefs.get(0));
    }

    public Iterator<Timeline.Key.Bone> boneIterator(Mainline.Key.BoneRef start) {
        this.boneIterator.index = start.id;
        return this.boneIterator;
    }

    public Iterator<Timeline.Key.Object> objectIterator() {
        return this.objectIterator(this.getCurrentKey().objectRefs.get(0));
    }

    public Iterator<Timeline.Key.Object> objectIterator(Mainline.Key.ObjectRef start) {
        this.objectIterator.index = start.id;
        return this.objectIterator;
    }

    public static abstract class Attachment
    extends Timeline.Key.Bone {
        private Timeline.Key.Bone parent;
        private final Point positionTemp = new Point();
        private final Point scaleTemp = new Point();
        private float angleTemp;

        public Attachment(Timeline.Key.Bone parent) {
            this.setParent(parent);
        }

        public void setParent(Timeline.Key.Bone parent) {
            if (parent == null) {
                throw new SpriterException("The parent cannot be null!");
            }
            this.parent = parent;
        }

        public Timeline.Key.Bone getParent() {
            return this.parent;
        }

        final void update() {
            this.positionTemp.set(this.position);
            this.scaleTemp.set(this.scale);
            this.angleTemp = this.angle;
            super.unmap(this.parent);
            this.setPosition(this.position.x, this.position.y);
            this.setScale(this.scale.x, this.scale.y);
            this.setAngle(this.angle);
            this.position.set(this.positionTemp);
            this.scale.set(this.scaleTemp);
            this.angle = this.angleTemp;
        }

        protected abstract void setPosition(float var1, float var2);

        protected abstract void setScale(float var1, float var2);

        protected abstract void setAngle(float var1);
    }

    public static interface PlayerListener {
        public void animationFinished(Animation var1);

        public void animationChanged(Animation var1, Animation var2);

        public void preProcess(Player var1);

        public void postProcess(Player var1);

        public void mainlineKeyChanged(Mainline.Key var1, Mainline.Key var2);
    }

    class BoneIterator
    implements Iterator<Timeline.Key.Bone> {
        int index = 0;

        BoneIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Player.this.getCurrentKey().boneRefs.size();
        }

        @Override
        public Timeline.Key.Bone next() {
            return Player.this.unmappedTweenedKeys[Player.this.getCurrentKey().boneRefs.get((int)this.index++).timeline].object();
        }

        @Override
        public void remove() {
            throw new SpriterException("remove() is not supported by this iterator!");
        }
    }

    class ObjectIterator
    implements Iterator<Timeline.Key.Object> {
        int index = 0;

        ObjectIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Player.this.getCurrentKey().objectRefs.size();
        }

        @Override
        public Timeline.Key.Object next() {
            return Player.this.unmappedTweenedKeys[Player.this.getCurrentKey().objectRefs.get((int)this.index++).timeline].object();
        }

        @Override
        public void remove() {
            throw new SpriterException("remove() is not supported by this iterator!");
        }
    }
}

