/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter.LibGdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.brashmonkey.spriter.Data;
import com.brashmonkey.spriter.FileReference;
import com.brashmonkey.spriter.Loader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LibGdxLoader
extends Loader<Sprite>
implements Disposable {
    public static int standardAtlasWidth = 2048;
    public static int standardAtlasHeight = 2048;
    private PixmapPacker packer;
    private HashMap<FileReference, Pixmap> pixmaps;
    private HashMap<Pixmap, Boolean> pixmapsToDispose;
    private boolean pack = true;
    private int atlasWidth;
    private int atlasHeight;

    public LibGdxLoader(Data data) {
        this(data, true);
    }

    public LibGdxLoader(Data data, boolean pack) {
        this(data, standardAtlasWidth, standardAtlasHeight);
        this.pack = pack;
    }

    public LibGdxLoader(Data data, int atlasWidth, int atlasHeight) {
        super(data);
        this.atlasWidth = atlasWidth;
        this.atlasHeight = atlasHeight;
        this.pixmaps = new HashMap();
        this.pixmapsToDispose = new HashMap();
    }

    @Override
    protected Sprite loadResource(FileReference ref) {
        FileHandle f;
        String pathPrefix = this.root == null || this.root.equals("") ? "" : this.root + File.separator;
        String path = pathPrefix + this.data.getFile((FileReference)ref).name;
        switch (Gdx.app.getType()) {
            case iOS: {
                f = Gdx.files.absolute(path);
                break;
            }
            default: {
                f = Gdx.files.internal(path);
            }
        }
        if (!f.exists()) {
            throw new GdxRuntimeException("Could not find file handle " + path + "! Please check your paths.");
        }
        if (this.packer == null && this.pack) {
            this.packer = new PixmapPacker(this.atlasWidth, this.atlasHeight, Pixmap.Format.RGBA8888, 2, true);
        }
        Pixmap pix = new Pixmap(f);
        this.pixmaps.put(ref, pix);
        return null;
    }

    protected void generatePackedSprites() {
        if (this.packer == null) {
            return;
        }
        TextureAtlas tex = this.packer.generateTextureAtlas(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear, false);
        Set keys = this.resources.keySet();
        this.disposeNonPackedTextures();
        for (FileReference ref : keys) {
            TextureAtlas.AtlasRegion texReg = tex.findRegion(this.data.getFile((FileReference)ref).name);
            texReg.setRegionWidth((int)this.data.getFile((FileReference)ref).size.width);
            texReg.setRegionHeight((int)this.data.getFile((FileReference)ref).size.height);
            this.resources.put(ref, new Sprite((TextureRegion)texReg));
        }
    }

    private void disposeNonPackedTextures() {
        for (Map.Entry entry : this.resources.entrySet()) {
            ((Sprite)entry.getValue()).getTexture().dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.pack && this.packer != null) {
            this.packer.dispose();
        } else {
            this.disposeNonPackedTextures();
        }
        super.dispose();
    }

    @Override
    protected void finishLoading() {
        Set refs = this.resources.keySet();
        for (FileReference ref : refs) {
            Pixmap pix = this.pixmaps.get(ref);
            this.pixmapsToDispose.put(pix, false);
            this.createSprite(ref, pix);
            if (this.packer == null) continue;
            this.packer.pack(this.data.getFile((FileReference)ref).name, pix);
        }
        if (this.pack) {
            this.generatePackedSprites();
        }
        this.disposePixmaps();
    }

    protected void createSprite(FileReference ref, Pixmap image) {
        Texture tex = new Texture(image);
        tex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        int width = (int)this.data.getFile((int)ref.folder, (int)ref.file).size.width;
        int height = (int)this.data.getFile((int)ref.folder, (int)ref.file).size.height;
        TextureRegion texRegion = new TextureRegion(tex, width, height);
        this.resources.put(ref, new Sprite(texRegion));
        this.pixmapsToDispose.put(image, true);
    }

    protected void disposePixmaps() {
        Pixmap[] maps = new Pixmap[this.pixmapsToDispose.size()];
        this.pixmapsToDispose.keySet().toArray(maps);
        for (Pixmap pix : maps) {
            try {
                while (this.pixmapsToDispose.get(pix).booleanValue()) {
                    pix.dispose();
                    this.pixmapsToDispose.put(pix, false);
                }
            }
            catch (GdxRuntimeException e) {
                System.err.println("Pixmap was already disposed!");
            }
        }
        this.pixmapsToDispose.clear();
    }
}

