/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.File;
import com.brashmonkey.spriter.FileReference;
import com.brashmonkey.spriter.Folder;
import java.util.ArrayList;
import java.util.List;

public class Data {
    final List<Folder> folders;
    final List<Entity> entities;
    public final String scmlVersion;
    public final String generator;
    public final String generatorVersion;

    Data(String scmlVersion, String generator, String generatorVersion) {
        this(scmlVersion, generator, generatorVersion, new ArrayList<Folder>(), new ArrayList<Entity>());
    }

    Data(String scmlVersion, String generator, String generatorVersion, List<Folder> folders, List<Entity> entities) {
        this.scmlVersion = scmlVersion;
        this.generator = generator;
        this.generatorVersion = generatorVersion;
        this.folders = folders;
        this.entities = entities;
    }

    void addFolder(Folder folder) {
        this.folders.add(folder);
    }

    void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public Folder getFolder(String name) {
        int index = this.getFolderIndex(name);
        if (index >= 0) {
            return this.getFolder(index);
        }
        return null;
    }

    int getFolderIndex(String name) {
        for (Folder folder : this.folders) {
            if (!folder.name.equals(name)) continue;
            return folder.id;
        }
        return -1;
    }

    Folder getFolder(int index) {
        return this.folders.get(index);
    }

    public Entity getEntity(int index) {
        return this.entities.get(index);
    }

    public Entity getEntity(String name) {
        int index = this.getEntityIndex(name);
        if (index >= 0) {
            return this.getEntity(index);
        }
        return null;
    }

    int getEntityIndex(String name) {
        for (Entity entity : this.entities) {
            if (!entity.name.equals(name)) continue;
            return entity.id;
        }
        return -1;
    }

    public File getFile(Folder folder, int file) {
        return folder.getFile(file);
    }

    public File getFile(int folder, int file) {
        return this.getFile(this.getFolder(folder), file);
    }

    public File getFile(FileReference ref) {
        return this.getFile(ref.folder, ref.file);
    }

    public String toString() {
        String toReturn = this.getClass().getSimpleName() + "|[Version: " + this.scmlVersion + ", Generator: " + this.generator + " (" + this.generatorVersion + ")]";
        for (Folder folder : this.folders) {
            toReturn = toReturn + "\n" + folder;
        }
        for (Entity entity : this.entities) {
            toReturn = toReturn + "\n" + entity;
        }
        toReturn = toReturn + "]";
        return toReturn;
    }
}

