/*
 * Decompiled with CFR 0.152.
 */
package basemod.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireEnum;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import java.util.List;

public class ModalChoiceScreen {
    private static float PAD_X;
    public List<AbstractCard> cardGroup;
    public boolean isOpen = false;
    private String header;
    private float showTimer;
    private CardGroup savedHand;
    private CardGroup exhaustCardGroup;
    private AbstractCard exhaustCard;

    public void open(List<AbstractCard> cards, String header) {
        PAD_X = 40.0f * Settings.scale;
        AbstractDungeon.topPanel.unhoverHitboxes();
        this.cardGroup = cards;
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = Enum.MODAL_CHOICE;
        this.header = header;
        AbstractDungeon.dynamicBanner.appear(header);
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.endTurnButton.disable();
        this.placeCards((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.45f);
        this.showTimer = 0.8f;
        this.isOpen = true;
    }

    public void reopen() {
        AbstractDungeon.screen = Enum.MODAL_CHOICE;
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.dynamicBanner.appear(this.header);
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.endTurnButton.disable();
    }

    public void close() {
        this.isOpen = false;
        AbstractDungeon.player.hand = this.savedHand;
        AbstractDungeon.overlayMenu.endTurnButton.enable();
        AbstractDungeon.dynamicBanner.hide();
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.NONE;
        AbstractDungeon.isScreenUp = false;
        if (this.exhaustCardGroup != null) {
            this.exhaustCardGroup.moveToExhaustPile(this.exhaustCard);
        }
    }

    private void fakeClose() {
        AbstractDungeon.overlayMenu.endTurnButton.disable();
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.NONE;
        AbstractDungeon.isScreenUp = false;
    }

    public void delayExhaust(CardGroup group, AbstractCard card) {
        this.exhaustCardGroup = group;
        this.exhaustCard = card;
    }

    public void update() {
        if (this.showTimer > 0.0f) {
            this.showTimer -= Gdx.graphics.getDeltaTime();
            if (Settings.FAST_MODE) {
                this.showTimer -= Gdx.graphics.getDeltaTime();
            }
            for (AbstractCard c : this.cardGroup) {
                c.update();
            }
            return;
        }
        this.savedHand = AbstractDungeon.player.hand;
        AbstractDungeon.player.hand = new CardGroup(CardGroup.CardGroupType.HAND);
        for (AbstractCard c : this.cardGroup) {
            AbstractDungeon.player.hand.addToHand(c);
        }
        this.fakeClose();
    }

    public void render(SpriteBatch sb) {
        this.renderCardReward(sb);
    }

    private void renderCardReward(SpriteBatch sb) {
        for (AbstractCard c : this.cardGroup) {
            c.render(sb);
        }
        for (AbstractCard c : this.cardGroup) {
            c.renderCardTip(sb);
        }
    }

    private void placeCards(float x, float y) {
        float spacing = AbstractCard.IMG_WIDTH;
        if (this.cardGroup.size() <= 5) {
            spacing += PAD_X;
        } else if (this.cardGroup.size() > 6) {
            spacing -= PAD_X;
        }
        for (int i = 0; i < this.cardGroup.size(); ++i) {
            this.cardGroup.get((int)i).target_y = y;
            this.cardGroup.get((int)i).target_x = (float)Settings.WIDTH / 2.0f;
            int posOffset = i - this.cardGroup.size() / 2;
            this.cardGroup.get((int)i).target_x += (float)posOffset * spacing;
            if (this.cardGroup.size() % 2 != 0) continue;
            this.cardGroup.get((int)i).target_x += spacing / 2.0f;
        }
        for (AbstractCard c : this.cardGroup) {
            c.drawScale = 0.75f;
            c.targetDrawScale = 0.75f;
            c.current_x = x;
            c.current_y = y;
        }
    }

    public static class Enum {
        @SpireEnum
        public static AbstractDungeon.CurrentScreen MODAL_CHOICE;
    }
}

