/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireField;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatches;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DescriptionLine;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import java.util.List;
import javassist.CtBehavior;

public class ShrinkLongDescription {

    @SpirePatches(value={@SpirePatch(clz=AbstractCard.class, method="renderDescription"), @SpirePatch(clz=AbstractCard.class, method="renderDescriptionCN")})
    public static class ShiftSizeLineDescription {
        @SpireInsertPatch(locator=Locator.class, localvars={"draw_y"})
        public static void Insert(AbstractCard __instance, SpriteBatch sb, @ByRef float[] draw_y) {
            if (__instance.description.size() > 5) {
                draw_y[0] = draw_y[0] - 6.0f * Settings.scale * __instance.drawScale;
            }
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
                Matcher.MethodCallMatcher finalMatcher = new Matcher.MethodCallMatcher(BitmapFont.class, "getCapHeight");
                return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatches(value={@SpirePatch(clz=AbstractCard.class, method="initializeDescription"), @SpirePatch(clz=AbstractCard.class, method="initializeDescriptionCN")})
    public static class ShrinkInitializeDescription {
        private static final float TARGET_HEIGHT = 95.0f * Settings.scale;
        private static final int MAX_DEPTH = 10;
        private static int depth = 0;

        public static void Prefix(AbstractCard __instance) {
            if (depth == 0) {
                Scale.descriptionScale.set((Object)__instance, (Object)Float.valueOf(1.0f));
            }
        }

        public static void Postfix(AbstractCard __instance) {
            float descHeight = ShrinkInitializeDescription.descriptionHeight(FontHelper.cardDescFont_N, __instance.description);
            if (__instance.description.size() > 6 && descHeight > TARGET_HEIGHT && depth < 10) {
                FontHelper.cardDescFont_N.getData().setScale(1.0f - (float)(++depth) * 0.05f);
                Scale.descriptionScale.set((Object)__instance, (Object)Float.valueOf(1.0f - (float)depth * 0.05f));
                __instance.initializeDescription();
                --depth;
                FontHelper.cardDescFont_N.getData().setScale(1.0f);
            } else if (depth >= 10) {
                // empty if block
            }
        }

        private static float descriptionHeight(BitmapFont font, List<DescriptionLine> description) {
            float height = 0.0f;
            GlyphLayout gl = new GlyphLayout();
            for (int i = 0; i < description.size(); ++i) {
                gl.setText(font, (CharSequence)description.get(i).getText());
                height += gl.height;
            }
            return height;
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="getDescFont")
    public static class ShrinkFontSize {
        public static BitmapFont Postfix(BitmapFont __result, AbstractCard __instance) {
            float scale = ((Float)Scale.descriptionScale.get((Object)__instance)).floatValue();
            if (scale != 1.0f) {
                __result = FontHelper.cardDescFont_L;
                __result.getData().setScale(__result.getScaleX() * scale, __result.getScaleY() * scale);
            }
            return __result;
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="<class>")
    public static class Scale {
        public static SpireField<Float> descriptionScale = new SpireField(() -> Float.valueOf(1.0f));
    }
}

