/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts;

import basemod.BaseMod;
import basemod.abstracts.CustomEnergyOrb;
import basemod.animations.AbstractAnimation;
import basemod.animations.G3DJAnimation;
import basemod.animations.SpineAnimation;
import basemod.interfaces.ModelRenderSubscriber;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.cutscenes.CutscenePanel;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.Prefs;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import com.megacrit.cardcrawl.localization.CharacterStrings;
import com.megacrit.cardcrawl.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.screens.CharSelectInfo;
import com.megacrit.cardcrawl.screens.stats.CharStat;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import com.megacrit.cardcrawl.ui.panels.energyorb.EnergyOrbInterface;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CustomPlayer
extends AbstractPlayer
implements ModelRenderSubscriber {
    private static final Logger logger = LogManager.getLogger((String)CustomPlayer.class.getName());
    protected AbstractAnimation animation;
    protected EnergyOrbInterface energyOrb;
    protected Prefs prefs;
    protected CharStat charStat;

    public CustomPlayer(String name, AbstractPlayer.PlayerClass playerClass, String[] orbTextures, String orbVfxPath, String model, String animation) {
        this(name, playerClass, orbTextures, orbVfxPath, null, model, animation);
    }

    public CustomPlayer(String name, AbstractPlayer.PlayerClass playerClass, EnergyOrbInterface energyOrbInterface, String model, String animation) {
        this(name, playerClass, energyOrbInterface, new G3DJAnimation(model, animation));
    }

    public CustomPlayer(String name, AbstractPlayer.PlayerClass playerClass, String[] orbTextures, String orbVfxPath, float[] layerSpeeds, String model, String animation) {
        this(name, playerClass, orbTextures, orbVfxPath, layerSpeeds, new G3DJAnimation(model, animation));
    }

    public CustomPlayer(String name, AbstractPlayer.PlayerClass playerClass, String[] orbTextures, String orbVfxPath, AbstractAnimation animation) {
        this(name, playerClass, orbTextures, orbVfxPath, null, animation);
    }

    public CustomPlayer(String name, AbstractPlayer.PlayerClass playerClass, String[] orbTextures, String orbVfxPath, float[] layerSpeeds, AbstractAnimation animation) {
        this(name, playerClass, new CustomEnergyOrb(orbTextures, orbVfxPath, layerSpeeds), animation);
    }

    public CustomPlayer(String name, AbstractPlayer.PlayerClass playerClass, EnergyOrbInterface energyOrbInterface, AbstractAnimation animation) {
        super(name, playerClass);
        this.energyOrb = energyOrbInterface;
        this.charStat = new CharStat((AbstractPlayer)this);
        this.dialogX = this.drawX + 0.0f * Settings.scale;
        this.dialogY = this.drawY + 220.0f * Settings.scale;
        this.animation = animation;
        if (animation instanceof SpineAnimation) {
            SpineAnimation spine = (SpineAnimation)animation;
            this.loadAnimation(spine.atlasUrl, spine.skeletonUrl, spine.scale);
        }
        if (animation.type() != AbstractAnimation.Type.NONE) {
            this.atlas = new TextureAtlas();
        }
        if (animation.type() == AbstractAnimation.Type.MODEL) {
            BaseMod.subscribe(this);
        }
    }

    @Override
    public void receiveModelRender(ModelBatch batch, Environment env) {
        if (this != AbstractDungeon.player) {
            BaseMod.unsubscribeLater(this);
        } else {
            this.animation.renderModel(batch, env);
        }
    }

    public void renderPlayerImage(SpriteBatch sb) {
        switch (this.animation.type()) {
            case NONE: {
                super.renderPlayerImage(sb);
                break;
            }
            case MODEL: {
                BaseMod.publishAnimationRender(sb);
                break;
            }
            case SPRITE: {
                this.animation.setFlip(this.flipHorizontal, this.flipVertical);
                this.animation.renderSprite(sb, this.drawX + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY);
            }
        }
    }

    public String getAchievementKey() {
        return "MODDING";
    }

    public ArrayList<AbstractCard> getCardPool(ArrayList<AbstractCard> tmpPool) {
        AbstractCard.CardColor color = this.getCardColor();
        for (Map.Entry c : CardLibrary.cards.entrySet()) {
            AbstractCard card = (AbstractCard)c.getValue();
            if (!card.color.equals((Object)color) || card.rarity == AbstractCard.CardRarity.BASIC || UnlockTracker.isCardLocked((String)((String)c.getKey())) && !Settings.isDailyRun) continue;
            tmpPool.add(card);
        }
        return tmpPool;
    }

    public String getLeaderboardCharacterName() {
        return null;
    }

    public Texture getEnergyImage() {
        if (this.energyOrb instanceof CustomEnergyOrb) {
            return ((CustomEnergyOrb)this.energyOrb).getEnergyImage();
        }
        throw new RuntimeException();
    }

    public TextureAtlas.AtlasRegion getOrb() {
        return BaseMod.getCardEnergyOrbAtlasRegion(this.getCardColor());
    }

    public void renderOrb(SpriteBatch sb, boolean enabled, float current_x, float current_y) {
        this.energyOrb.renderOrb(sb, enabled, current_x, current_y);
    }

    public void updateOrb(int energyCount) {
        this.energyOrb.updateOrb(energyCount);
    }

    public String getSaveFilePath() {
        return SaveAndContinue.getPlayerSavePath((AbstractPlayer.PlayerClass)this.chosenClass);
    }

    public Prefs getPrefs() {
        if (this.prefs == null) {
            logger.error("prefs need to be initialized first!");
        }
        return this.prefs;
    }

    public void loadPrefs() {
        if (this.prefs == null) {
            this.prefs = SaveHelper.getPrefs((String)this.chosenClass.name());
        }
    }

    public CharStat getCharStat() {
        return this.charStat;
    }

    public int getUnlockedCardCount() {
        return 0;
    }

    public int getSeenCardCount() {
        return BaseMod.getSeenCardCount(this.getCardColor());
    }

    public int getCardCount() {
        return BaseMod.getCardCount(this.getCardColor());
    }

    public boolean saveFileExists() {
        return SaveAndContinue.saveExistsAndNotCorrupted((AbstractPlayer)this);
    }

    public String getWinStreakKey() {
        return "win_streak_" + this.chosenClass.name();
    }

    public String getLeaderboardWinStreakKey() {
        return this.chosenClass.name() + "_CONSECUTIVE_WINS";
    }

    public void renderStatScreen(SpriteBatch sb, float screenX, float screenY) {
        StatsScreen.renderHeader((SpriteBatch)sb, (String)BaseMod.colorString(this.getLocalizedCharacterName(), "#" + this.getCardRenderColor().toString()), (float)screenX, (float)screenY);
        this.getCharStat().render(sb, screenX, screenY);
    }

    public Texture getCustomModeCharacterButtonImage() {
        if (BaseMod.getCustomModePlayerButton(this.chosenClass) != null) {
            return ImageMaster.loadImage((String)BaseMod.getCustomModePlayerButton(this.chosenClass));
        }
        Pixmap pixmap = new Pixmap(Gdx.files.internal(BaseMod.getPlayerButton(this.chosenClass)));
        Pixmap small = new Pixmap(128, 128, pixmap.getFormat());
        small.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 20, 20, small.getWidth() - 40, small.getHeight() - 40);
        Texture texture = new Texture(small);
        pixmap.dispose();
        small.dispose();
        return texture;
    }

    public CharacterStrings getCharacterString() {
        CharSelectInfo loadout = this.getLoadout();
        CharacterStrings characterStrings = new CharacterStrings();
        characterStrings.NAMES = new String[]{loadout.name};
        characterStrings.TEXT = new String[]{loadout.flavorText};
        return characterStrings;
    }

    public void refreshCharStat() {
        this.charStat = new CharStat((AbstractPlayer)this);
    }

    public void movePosition(float x, float y) {
        float dialogOffsetX = this.dialogX - this.drawX;
        float dialogOffsetY = this.dialogY - this.drawY;
        this.drawX = x;
        this.drawY = y;
        this.dialogX = this.drawX + dialogOffsetX;
        this.dialogY = this.drawY + dialogOffsetY;
        this.animX = 0.0f;
        this.animY = 0.0f;
        this.refreshHitboxLocation();
    }

    public Texture getCutsceneBg() {
        return ImageMaster.loadImage((String)"images/scenes/redBg.jpg");
    }

    public List<CutscenePanel> getCutscenePanels() {
        ArrayList<CutscenePanel> panels = new ArrayList<CutscenePanel>();
        panels.add(new CutscenePanel("images/scenes/ironclad1.png", "ATTACK_HEAVY"));
        panels.add(new CutscenePanel("images/scenes/ironclad2.png"));
        panels.add(new CutscenePanel("images/scenes/ironclad3.png"));
        return panels;
    }

    public void updateVictoryVfx(ArrayList<AbstractGameEffect> effects) {
    }
}

