/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionHacks {
    public static final Logger logger = LogManager.getLogger((String)ReflectionHacks.class.getName());

    private ReflectionHacks() {
    }

    public static Object getPrivateStatic(Class<?> objClass, String fieldName) {
        try {
            Field targetField = objClass.getDeclaredField(fieldName);
            targetField.setAccessible(true);
            return targetField.get(null);
        }
        catch (Exception e) {
            logger.error("Exception occurred when getting private static field " + fieldName + " of " + objClass.getName(), (Throwable)e);
            return null;
        }
    }

    public static void setPrivateStatic(Class<?> objClass, String fieldName, Object newValue) {
        try {
            Field targetField = objClass.getDeclaredField(fieldName);
            targetField.setAccessible(true);
            targetField.set(null, newValue);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private static field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static void setPrivateStaticFinal(Class<?> objClass, String fieldName, Object newValue) {
        try {
            Field targetField = objClass.getDeclaredField(fieldName);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(targetField, targetField.getModifiers() & 0xFFFFFFEF);
            targetField.setAccessible(true);
            targetField.set(null, newValue);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private static (final) field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static Object getPrivate(Object obj, Class<?> objClass, String fieldName) {
        try {
            Field targetField = objClass.getDeclaredField(fieldName);
            targetField.setAccessible(true);
            return targetField.get(obj);
        }
        catch (Exception e) {
            logger.error("Exception occurred when getting private field " + fieldName + " of " + objClass.getName(), (Throwable)e);
            return null;
        }
    }

    public static void setPrivate(Object obj, Class<?> objClass, String fieldName, Object newValue) {
        try {
            Field targetField = objClass.getDeclaredField(fieldName);
            targetField.setAccessible(true);
            targetField.set(obj, newValue);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static void setPrivateInherited(Object obj, Class<?> objClass, String fieldName, Object newValue) {
        try {
            Field targetField = objClass.getSuperclass().getDeclaredField(fieldName);
            targetField.setAccessible(true);
            targetField.set(obj, newValue);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private field " + fieldName + " of the superclass of " + objClass.getName(), (Throwable)e);
        }
    }
}

