/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.AutoComplete;
import basemod.BaseMod;
import basemod.ConsoleInputProcessor;
import basemod.devcommands.ConsoleCommand;
import basemod.interfaces.PostEnergyRechargeSubscriber;
import basemod.interfaces.PostInitializeSubscriber;
import basemod.interfaces.PostRenderSubscriber;
import basemod.interfaces.PostUpdateSubscriber;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DevConsole
implements PostEnergyRechargeSubscriber,
PostInitializeSubscriber,
PostRenderSubscriber,
PostUpdateSubscriber {
    public static final Logger logger = LogManager.getLogger((String)DevConsole.class.getName());
    public static final float CONSOLE_X = 200.0f;
    public static final float CONSOLE_Y = 200.0f;
    public static final float CONSOLE_W = 800.0f;
    public static final float CONSOLE_H = 40.0f;
    public static final float CONSOLE_PAD_X = 15.0f;
    public static final int CONSOLE_TEXT_SIZE = 30;
    private static final int MAX_LINES = 8;
    public static final String PATTERN = "[\\s]+";
    public static final String PROMPT = "$> ";
    public static BitmapFont consoleFont = null;
    private static InputProcessor consoleInputProcessor;
    private static InputProcessor otherInputProcessor;
    public static Texture consoleBackground;
    public static boolean infiniteEnergy;
    public static boolean forceUnlocks;
    public static int unlockLevel;
    public static boolean enabled;
    public static boolean visible;
    public static int toggleKey;
    public static String currentText;
    public static int priorKey;
    public static int nextKey;
    public static ArrayList<String> priorCommands;
    public static ArrayList<String> log;
    public static ArrayList<Boolean> prompted;
    public static int commandPos;

    public DevConsole() {
        BaseMod.subscribe(this);
        priorCommands = new ArrayList();
        commandPos = -1;
        log = new ArrayList();
        prompted = new ArrayList();
        AutoComplete.init();
        ConsoleCommand.initialize();
    }

    public static void execute() {
        String[] tokens = currentText.trim().split(PATTERN);
        if (priorCommands.size() == 0 || !priorCommands.get(0).equals(currentText)) {
            priorCommands.add(0, currentText);
        }
        log.add(0, currentText);
        prompted.add(0, true);
        commandPos = -1;
        currentText = "";
        if (tokens.length < 1) {
            return;
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        ConsoleCommand.execute(tokens);
    }

    public static void couldNotParse() {
        DevConsole.log("could not parse previous command");
    }

    @Override
    public void receivePostEnergyRecharge() {
        if (infiniteEnergy) {
            EnergyPanel.setEnergy((int)9999);
        }
    }

    @Override
    public void receivePostInitialize() {
        consoleInputProcessor = new ConsoleInputProcessor();
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("font/Kreon-Regular.ttf"));
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = (int)(30.0f * Settings.scale);
        consoleFont = generator.generateFont(parameter);
        generator.dispose();
        consoleBackground = ImageMaster.loadImage((String)"img/ConsoleBackground.png");
        AutoComplete.postInit();
    }

    public static void log(String text) {
        log.add(0, text);
        prompted.add(0, false);
    }

    public static void log(ArrayList list) {
        for (Object o : list) {
            DevConsole.log(o.toString());
        }
    }

    @Override
    public void receivePostRender(SpriteBatch sb) {
        if (visible && consoleFont != null) {
            int sizeToDraw = log.size() + 1;
            if (sizeToDraw > 8) {
                sizeToDraw = 8;
            }
            sb.draw(consoleBackground, 200.0f * Settings.scale, 200.0f * Settings.scale, 800.0f * Settings.scale, 40.0f * Settings.scale + 30.0f * Settings.scale * (float)(sizeToDraw - 1));
            if (AutoComplete.enabled) {
                AutoComplete.render(sb);
            }
            float x = 200.0f * Settings.scale + 15.0f * Settings.scale;
            float y = 200.0f * Settings.scale + (float)Math.floor(30.0f * Settings.scale);
            consoleFont.draw((Batch)sb, (CharSequence)(PROMPT + currentText), x, y);
            for (int i = 0; i < sizeToDraw - 1; ++i) {
                consoleFont.draw((Batch)sb, (CharSequence)((prompted.get(i) != false ? PROMPT : "") + log.get(i)), x, y += (float)Math.floor(30.0f * Settings.scale));
            }
        }
    }

    @Override
    public void receivePostUpdate() {
        if (Gdx.input.isKeyJustPressed(toggleKey)) {
            AutoComplete.reset();
            if (visible) {
                currentText = "";
                commandPos = -1;
            } else {
                otherInputProcessor = Gdx.input.getInputProcessor();
                if (AutoComplete.enabled) {
                    AutoComplete.suggest(false);
                }
            }
            if (visible || enabled) {
                Gdx.input.setInputProcessor(visible ? otherInputProcessor : consoleInputProcessor);
                boolean bl = visible = !visible;
            }
        }
        if (AutoComplete.enabled && Gdx.input.isKeyPressed(AutoComplete.selectKey)) {
            if (Gdx.input.isKeyJustPressed(priorKey) && visible) {
                AutoComplete.selectUp();
            }
            if (Gdx.input.isKeyJustPressed(nextKey) && visible) {
                AutoComplete.selectDown();
            }
        } else {
            if (Gdx.input.isKeyJustPressed(priorKey) && visible && commandPos + 1 < priorCommands.size()) {
                currentText = priorCommands.get(++commandPos);
                AutoComplete.resetAndSuggest();
            }
            if (Gdx.input.isKeyJustPressed(nextKey) && visible) {
                if (commandPos - 1 < 0) {
                    currentText = "";
                    commandPos = -1;
                } else {
                    currentText = priorCommands.get(--commandPos);
                }
                AutoComplete.resetAndSuggest();
            }
        }
        if (AutoComplete.enabled && (Gdx.input.isKeyJustPressed(AutoComplete.fillKey1) || Gdx.input.isKeyJustPressed(AutoComplete.fillKey2))) {
            AutoComplete.fillInSuggestion();
        }
        if (Gdx.input.isKeyJustPressed(AutoComplete.deleteTokenKey)) {
            AutoComplete.removeOneTokenUsingSpaceAndIdDelimiter();
            if (AutoComplete.enabled) {
                AutoComplete.suggest(false);
            }
        }
    }

    static {
        otherInputProcessor = null;
        consoleBackground = null;
        infiniteEnergy = false;
        forceUnlocks = false;
        unlockLevel = -1;
        enabled = false;
        visible = false;
        toggleKey = 68;
        currentText = "";
        priorKey = 19;
        nextKey = 20;
    }
}

