/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoComplete {
    private static int ID_CREATOR = -1;
    public static final int RESET = ID_CREATOR++;
    private static final int MAX_SUGGESTIONS = 5;
    private static final Color TEXT_COLOR = Color.GRAY.cpy();
    private static final Color HIGHLIGHT_COLOR = Color.LIGHT_GRAY.cpy();
    public static boolean enabled = true;
    public static int selectKey = 59;
    public static int deleteTokenKey = 21;
    public static int fillKey1 = 22;
    public static int fillKey2 = 61;
    public static int selected = 0;
    private static ArrayList<String> suggestions;
    private static Stack<Pair> suggestionPairs;
    private static String[] tokens;
    private static boolean foundStart;
    private static boolean foundEnd;
    private static boolean noMatch;
    private static int currentID;
    private static int lastLength;
    private static int whiteSpaces;
    private static int lastWhiteSpaces;
    private static Pattern spacePattern;
    private static boolean implementedYet;
    private static float drawX;
    private static float promptWidth;
    private static GlyphLayout glyphs;
    private static final char ID_DELIMITER = ':';
    private static final String SPACE_AND_ID_DELIMITER = "[ :]";

    public static void init() {
        AutoComplete.reset();
    }

    public static void postInit() {
        glyphs = new GlyphLayout(DevConsole.consoleFont, (CharSequence)"$> ");
        promptWidth = AutoComplete.glyphs.width;
        AutoComplete.calculateDrawX();
        AutoComplete.suggest(false);
    }

    public static void reset() {
        AutoComplete.calculateDrawX();
        currentID = RESET;
        suggestions = new ArrayList();
        suggestionPairs = new Stack();
        tokens = new String[0];
        selected = 0;
        noMatch = false;
        foundEnd = false;
        foundStart = false;
        whiteSpaces = 0;
        lastWhiteSpaces = 0;
        lastLength = 0;
    }

    public static void resetAndSuggest() {
        if (enabled) {
            AutoComplete.reset();
            lastWhiteSpaces = AutoComplete.countSpaces();
            AutoComplete.suggest(false);
        }
    }

    public static void selectUp() {
        if (!(selected <= 0 || noMatch || suggestions.isEmpty() || suggestionPairs.isEmpty())) {
            --selected;
        }
    }

    public static void selectDown() {
        if (!(noMatch || suggestions.isEmpty() || suggestionPairs.isEmpty())) {
            Pair pair = suggestionPairs.peek();
            if (selected < pair.end - pair.start && selected < suggestions.size() - 1) {
                ++selected;
            }
        }
    }

    public static void fillInSuggestion() {
        if (!(noMatch || suggestions.isEmpty() || suggestionPairs.isEmpty())) {
            String textToInsert = suggestions.get(selected + AutoComplete.suggestionPairs.peek().start);
            if (textToInsert.lastIndexOf(58) > DevConsole.currentText.lastIndexOf(58)) {
                DevConsole.currentText = AutoComplete.getTextWithoutRightmostSpaceToken() + textToInsert.substring(0, textToInsert.lastIndexOf(58)) + ':';
            } else {
                DevConsole.currentText = AutoComplete.getTextWithoutRightmostSpaceToken() + textToInsert + " ";
                AutoComplete.reset();
            }
            AutoComplete.suggest(false);
        }
    }

    private static String getTextWithoutRightmostSpaceToken() {
        int lastSpace = DevConsole.currentText.lastIndexOf(32);
        String text = "";
        if (lastSpace != -1) {
            text = DevConsole.currentText.substring(0, lastSpace + 1);
        }
        return text;
    }

    private static int lastIndexOfRegex(String currentText, String tokenDelimiter) {
        int index = -1;
        Matcher matcher = Pattern.compile(tokenDelimiter).matcher(currentText);
        while (matcher.find()) {
            index = matcher.start();
        }
        return index;
    }

    public static void removeOneTokenUsingSpaceAndIdDelimiter() {
        String text = "";
        int lastChar = AutoComplete.lastIndexOfRegex(DevConsole.currentText, SPACE_AND_ID_DELIMITER);
        int curTextLength = DevConsole.currentText.length();
        if (lastChar != -1 && !DevConsole.currentText.isEmpty()) {
            text = DevConsole.currentText.charAt(curTextLength - 1) == ' ' ? DevConsole.currentText.substring(0, curTextLength - 1) : (DevConsole.currentText.charAt(curTextLength - 1) == ':' ? AutoComplete.getTextWithoutRightmostSpaceToken() : DevConsole.currentText.substring(0, lastChar + 1));
        }
        DevConsole.currentText = text;
    }

    private static int countSpaces() {
        int spaces = 0;
        Matcher spaceMatcher = spacePattern.matcher(DevConsole.currentText);
        while (spaceMatcher.find()) {
            if (spaceMatcher.start() == 0) continue;
            ++spaces;
        }
        return spaces;
    }

    public static void suggest(boolean isCharacterRemoved) {
        if (DevConsole.currentText.matches(".*\\s+")) {
            tokens = (DevConsole.currentText + "d").trim().split("[\\s]+");
            AutoComplete.tokens[AutoComplete.tokens.length - 1] = "";
        } else {
            tokens = DevConsole.currentText.trim().split("[\\s]+");
        }
        whiteSpaces = AutoComplete.countSpaces();
        AutoComplete.createCMDSuggestions();
        if (AutoComplete.tokenLengthChanged() || DevConsole.currentText.isEmpty() || currentID == RESET) {
            suggestionPairs.clear();
        }
        if (currentID == RESET) {
            suggestions.clear();
        }
        if (isCharacterRemoved && !AutoComplete.tokenLengthChanged() && suggestionPairs.size() >= 2) {
            suggestionPairs.pop();
            selected = 0;
            if (AutoComplete.suggestionPairs.peek().end <= -1) {
                noMatch = true;
            }
        } else {
            AutoComplete.createPair();
        }
        AutoComplete.calculateDrawX();
        lastWhiteSpaces = whiteSpaces;
    }

    private static boolean tokenLengthChanged() {
        return lastLength != tokens.length;
    }

    private static boolean whiteSpacesIncreased() {
        return whiteSpaces > lastWhiteSpaces;
    }

    private static void createPair() {
        if (AutoComplete.whiteSpacesIncreased()) {
            AutoComplete.createPair(" ");
            return;
        }
        AutoComplete.createPair(tokens[tokens.length - 1]);
    }

    private static void createPair(String prefix) {
        selected = 0;
        Pair pair = null;
        pair = !suggestionPairs.isEmpty() ? suggestionPairs.peek().cpy() : new Pair(0, suggestions.size() - 1);
        if (AutoComplete.shouldShowAll(prefix)) {
            foundEnd = true;
            foundStart = true;
            noMatch = false;
            suggestionPairs.push(pair.set(0, suggestions.size() - 1));
            return;
        }
        AutoComplete.linearSearch(pair, prefix);
    }

    private static boolean shouldShowAll(String prefix) {
        if (DevConsole.currentText.isEmpty()) {
            return true;
        }
        return prefix == null || prefix.isEmpty() || prefix.equals(" ") || DevConsole.currentText.lastIndexOf(32) == DevConsole.currentText.length() - 1;
    }

    private static void linearSearch(Pair pair, String prefix) {
        String lowerCasePrefix = prefix.toLowerCase();
        noMatch = false;
        foundEnd = false;
        foundStart = false;
        int size = suggestions.size();
        while (!foundStart && !noMatch) {
            if (pair.start >= size) {
                noMatch = true;
                continue;
            }
            if (suggestions.get(pair.start).toLowerCase().startsWith(lowerCasePrefix)) {
                foundStart = true;
                continue;
            }
            ++pair.start;
        }
        if (foundStart) {
            pair.end = pair.start + 1;
            while (!foundEnd) {
                if (pair.end >= size || !suggestions.get(pair.end).toLowerCase().startsWith(lowerCasePrefix)) {
                    foundEnd = true;
                    --pair.end;
                    continue;
                }
                ++pair.end;
            }
        }
        if (noMatch) {
            pair.set(Integer.MAX_VALUE, Integer.MIN_VALUE);
        }
        suggestionPairs.push(pair);
    }

    private static void createCMDSuggestions() {
        currentID = RESET + 1;
        suggestions = ConsoleCommand.suggestions(tokens);
    }

    private static void calculateDrawX() {
        drawX = 200.0f * Settings.scale + promptWidth + 15.0f * Settings.scale + AutoComplete.textLength();
    }

    private static float textLength() {
        if (glyphs == null || DevConsole.currentText.isEmpty()) {
            return 0.0f;
        }
        glyphs.setText(DevConsole.consoleFont, (CharSequence)AutoComplete.getTextWithoutRightmostSpaceToken());
        return AutoComplete.glyphs.width;
    }

    private static boolean shouldRenderInfo() {
        return suggestionPairs.isEmpty() || suggestions.isEmpty() || ConsoleCommand.errormsg != null || ConsoleCommand.complete;
    }

    public static void render(SpriteBatch sb) {
        DevConsole.consoleFont.setColor(HIGHLIGHT_COLOR);
        if (AutoComplete.shouldRenderInfo()) {
            sb.draw(DevConsole.consoleBackground, AutoComplete.getBGX(), 200.0f * Settings.scale, AutoComplete.getWidth(), -AutoComplete.getHeight());
            String text = "[No Match found]";
            if (!implementedYet) {
                text = "[Not implemented yet]";
            }
            if (suggestions.isEmpty() && ConsoleCommand.isNumber) {
                text = "[Number]";
            }
            if (suggestions.isEmpty() && ConsoleCommand.duringRun) {
                text = "[Only available during a run]";
            }
            if (ConsoleCommand.errormsg != null) {
                text = "[" + ConsoleCommand.errormsg + "]";
            }
            if (ConsoleCommand.complete) {
                text = "[Command is complete]";
            }
            DevConsole.consoleFont.draw((Batch)sb, (CharSequence)text, drawX, 200.0f * Settings.scale);
        } else {
            int item;
            int item2;
            int factor;
            Pair pair = suggestionPairs.peek();
            int amount = pair.end - selected;
            if (amount > 5) {
                amount = 5;
            }
            if (amount > pair.end - pair.start) {
                amount = pair.end - pair.start;
            }
            float y = 200.0f * Settings.scale + (float)Math.floor(30.0f * Settings.scale);
            for (factor = 1; factor <= amount && (item2 = selected + pair.start + factor) <= pair.end && item2 < suggestions.size(); ++factor) {
            }
            sb.draw(DevConsole.consoleBackground, AutoComplete.getBGX(), 200.0f * Settings.scale, AutoComplete.getWidth(), -AutoComplete.getHeight() * (float)factor);
            for (int i = 0; i <= amount && (item = selected + pair.start + i) <= pair.end && item < suggestions.size(); ++i) {
                DevConsole.consoleFont.draw((Batch)sb, (CharSequence)suggestions.get(item), drawX, y -= (float)Math.floor(30.0f * Settings.scale));
                DevConsole.consoleFont.setColor(TEXT_COLOR);
            }
        }
        DevConsole.consoleFont.setColor(Color.WHITE);
    }

    private static float getBGX() {
        return drawX - 15.0f * Settings.scale;
    }

    private static float getWidth() {
        return 800.0f * Settings.scale - drawX + 200.0f * Settings.scale + 15.0f * Settings.scale;
    }

    private static float getHeight() {
        return 30.0f * Settings.scale;
    }

    static {
        lastLength = 0;
        whiteSpaces = 0;
        lastWhiteSpaces = 0;
        spacePattern = Pattern.compile("[\\s]+");
        implementedYet = true;
        promptWidth = 0.0f;
    }

    public static class Pair {
        public int start;
        public int end;

        public Pair(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public Pair cpy() {
            return new Pair(this.start, this.end);
        }

        public Pair set(int start, int end) {
            this.start = start;
            this.end = end;
            return this;
        }
    }
}

