/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Calculator;

public class Point {
    public float x;
    public float y;

    public Point() {
        this(0.0f, 0.0f);
    }

    public Point(Point point) {
        this(point.x, point.y);
    }

    public Point(float x, float y) {
        this.set(x, y);
    }

    public Point set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point translate(float x, float y) {
        return this.set(this.x + x, this.y + y);
    }

    public Point scale(float x, float y) {
        return this.set(this.x * x, this.y * y);
    }

    public Point set(Point point) {
        return this.set(point.x, point.y);
    }

    public Point translate(Point amount) {
        return this.translate(amount.x, amount.y);
    }

    public Point scale(Point amount) {
        return this.scale(amount.x, amount.y);
    }

    public Point rotate(float degrees) {
        if (this.x != 0.0f || this.y != 0.0f) {
            float cos = Calculator.cosDeg(degrees);
            float sin = Calculator.sinDeg(degrees);
            float xx = this.x * cos - this.y * sin;
            float yy = this.x * sin + this.y * cos;
            this.x = xx;
            this.y = yy;
        }
        return this;
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }
}

