/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Animation;
import com.brashmonkey.spriter.Dimension;
import com.brashmonkey.spriter.FileReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Entity {
    public final int id;
    public final String name;
    private final List<Animation> animations;
    private final HashMap<String, Animation> namedAnimations;
    private final List<CharacterMap> characterMaps;
    private final List<ObjectInfo> objectInfos;

    Entity(int id, String name) {
        this(id, name, new ArrayList<Animation>(), new ArrayList<CharacterMap>(), new ArrayList<ObjectInfo>());
    }

    Entity(int id, String name, List<Animation> animations, List<CharacterMap> characterMaps, List<ObjectInfo> objectInfos) {
        this.id = id;
        this.name = name;
        this.animations = animations;
        this.characterMaps = characterMaps;
        this.objectInfos = objectInfos;
        this.namedAnimations = new HashMap();
    }

    void addAnimation(Animation anim) {
        this.animations.add(anim);
        this.namedAnimations.put(anim.name, anim);
    }

    public Animation getAnimation(int index) {
        return this.animations.get(index);
    }

    public Animation getAnimation(String name) {
        return this.namedAnimations.get(name);
    }

    public int animations() {
        return this.animations.size();
    }

    public boolean containsAnimation(Animation anim) {
        return this.animations.contains(anim);
    }

    public Animation getAnimationWithMostTimelines() {
        Animation maxAnim = this.getAnimation(0);
        for (Animation anim : this.animations) {
            if (maxAnim.timelines() >= anim.timelines()) continue;
            maxAnim = anim;
        }
        return maxAnim;
    }

    public CharacterMap getCharacterMap(String name) {
        for (CharacterMap map : this.characterMaps) {
            if (!map.name.equals(name)) continue;
            return map;
        }
        return null;
    }

    void addCharacterMap(CharacterMap map) {
        this.characterMaps.add(map);
    }

    void addInfo(ObjectInfo info) {
        this.objectInfos.add(info);
    }

    public ObjectInfo getInfo(int index) {
        return this.objectInfos.get(index);
    }

    public ObjectInfo getInfo(String name) {
        for (ObjectInfo info : this.objectInfos) {
            if (!info.name.equals(name)) continue;
            return info;
        }
        return null;
    }

    public ObjectInfo getInfo(String name, ObjectType type) {
        ObjectInfo info = this.getInfo(name);
        if (info != null && info.type == type) {
            return info;
        }
        return null;
    }

    public String toString() {
        String toReturn = this.getClass().getSimpleName() + "|[id: " + this.id + ", name: " + this.name + "]";
        toReturn = toReturn + "Object infos:\n";
        for (ObjectInfo info : this.objectInfos) {
            toReturn = toReturn + "\n" + info;
        }
        toReturn = toReturn + "Character maps:\n";
        for (CharacterMap map : this.characterMaps) {
            toReturn = toReturn + "\n" + map;
        }
        toReturn = toReturn + "Animations:\n";
        for (Animation animaton : this.animations) {
            toReturn = toReturn + "\n" + animaton;
        }
        toReturn = toReturn + "]";
        return toReturn;
    }

    public static class CharacterMap
    extends HashMap<FileReference, FileReference> {
        private static final long serialVersionUID = 6062776450159802283L;
        public final int id;
        public final String name;

        public CharacterMap(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public FileReference get(FileReference key) {
            if (!super.containsKey(key)) {
                return key;
            }
            return (FileReference)super.get(key);
        }
    }

    public static class ObjectInfo {
        public final ObjectType type;
        public final List<FileReference> frames;
        public final String name;
        public final Dimension size;

        ObjectInfo(String name, ObjectType type, Dimension size, List<FileReference> frames) {
            this.type = type;
            this.frames = frames;
            this.name = name;
            this.size = size;
        }

        ObjectInfo(String name, ObjectType type, Dimension size) {
            this(name, type, size, new ArrayList<FileReference>());
        }

        ObjectInfo(String name, ObjectType type, List<FileReference> frames) {
            this(name, type, new Dimension(0.0f, 0.0f), frames);
        }

        public String toString() {
            return this.name + ": " + (Object)((Object)this.type) + ", size: " + this.size + "|frames:\n" + this.frames;
        }
    }

    public static enum ObjectType {
        Sprite,
        Bone,
        Box,
        Point,
        Skin;


        public static ObjectType getObjectInfoFor(String name) {
            if (name.equals("bone")) {
                return Bone;
            }
            if (name.equals("skin")) {
                return Skin;
            }
            if (name.equals("box")) {
                return Box;
            }
            if (name.equals("point")) {
                return Point;
            }
            return Sprite;
        }
    }
}

