/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.whatmod;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class WhatMod {
    public static boolean enabled = true;
    private static final float BODY_TEXT_WIDTH = 280.0f * Settings.scale;
    private static final float TIP_DESC_LINE_SPACING = 26.0f * Settings.scale;

    static void renderModTooltip(SpriteBatch sb, Class<?> cls) {
        WhatMod.renderModTooltip(sb, cls, 1300.0f * Settings.scale, 700.0f * Settings.scale);
    }

    static void renderModTooltip(SpriteBatch sb, Class<?> cls, float x, float y) {
        String title = "What mod is this from?";
        try {
            String body = WhatMod.findModName(cls);
            if (body == null) {
                body = "Not modded content";
            }
            Field textHeight = TipHelper.class.getDeclaredField("textHeight");
            textHeight.setAccessible(true);
            Method renderTipBox = TipHelper.class.getDeclaredMethod("renderTipBox", Float.TYPE, Float.TYPE, SpriteBatch.class, String.class, String.class);
            renderTipBox.setAccessible(true);
            textHeight.setFloat(null, -FontHelper.getSmartHeight((BitmapFont)FontHelper.tipBodyFont, (String)body, (float)BODY_TEXT_WIDTH, (float)TIP_DESC_LINE_SPACING) - 7.0f * Settings.scale);
            renderTipBox.invoke(null, Float.valueOf(x), Float.valueOf(y), sb, title, body);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static URL findModURL(Class<?> cls) {
        URL locationURL = cls.getProtectionDomain().getCodeSource().getLocation();
        if (locationURL == null) {
            try {
                ClassPool pool = Loader.getClassPool();
                pool.childFirstLookup = true;
                CtClass ctCls = pool.get(cls.getName());
                String url = ctCls.getURL().getFile();
                int i = url.lastIndexOf(33);
                url = url.substring(0, i);
                locationURL = new URL(url);
            }
            catch (MalformedURLException | NotFoundException ignored) {
                return null;
            }
        }
        return locationURL;
    }

    public static String findModName(Class<?> cls) {
        URL locationURL = WhatMod.findModURL(cls);
        if (locationURL == null) {
            return "Unknown";
        }
        try {
            if (locationURL.equals(new File(Loader.STS_JAR).toURI().toURL())) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "Unknown";
        }
        for (ModInfo modInfo : Loader.MODINFOS) {
            if (!locationURL.equals(modInfo.jarURL)) continue;
            return modInfo.Name;
        }
        return "Unknown";
    }

    public static String findModID(Class<?> cls) {
        URL locationURL = WhatMod.findModURL(cls);
        if (locationURL == null) {
            return "<unknown>";
        }
        try {
            if (locationURL.equals(new File(Loader.STS_JAR).toURI().toURL())) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "<unknown>";
        }
        for (ModInfo modInfo : Loader.MODINFOS) {
            if (!locationURL.equals(modInfo.jarURL)) continue;
            return modInfo.ID;
        }
        return "<unknown>";
    }
}

