/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.maxhp;

import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import java.util.ArrayList;

public class MaxHp
extends ConsoleCommand {
    public MaxHp() {
        this.requiresPlayer = true;
        this.minExtraTokens = 2;
        this.maxExtraTokens = 2;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        if (tokens[1].toLowerCase().equals("add") || tokens[1].toLowerCase().equals("a")) {
            try {
                int i = Integer.parseInt(tokens[2]);
                AbstractDungeon.player.increaseMaxHp(i, true);
            }
            catch (Exception e) {
                MaxHp.cmdMaxHPHelp();
            }
        } else if (tokens[1].toLowerCase().equals("lose") || tokens[1].toLowerCase().equals("l")) {
            try {
                int i = Integer.parseInt(tokens[2]);
                AbstractDungeon.player.decreaseMaxHealth(i);
            }
            catch (Exception e) {
                MaxHp.cmdMaxHPHelp();
            }
        } else {
            MaxHp.cmdMaxHPHelp();
        }
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("add");
        result.add("lose");
        if (tokens.length == depth + 1) {
            return result;
        }
        if (result.contains(tokens[depth])) {
            if (tokens[depth + 1].matches("\\d+")) {
                complete = true;
            }
            result = MaxHp.smallNumbers();
        }
        return result;
    }

    @Override
    public void errorMsg() {
        MaxHp.cmdMaxHPHelp();
    }

    private static void cmdMaxHPHelp() {
        DevConsole.couldNotParse();
        DevConsole.log("options are:");
        DevConsole.log("* add [amt]");
        DevConsole.log("* lose [amt]");
    }
}

