/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts;

import basemod.animations.AbstractAnimation;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireOverride;
import com.evacipated.cardcrawl.modthespire.lib.SpireSuper;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ShaderHelper;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public abstract class CustomMonster
extends AbstractMonster {
    protected AbstractAnimation animation;

    public CustomMonster(String name, String id, int maxHealth, float hb_x, float hb_y, float hb_w, float hb_h, String imgUrl, float offsetX, float offsetY) {
        super(name, id, maxHealth, hb_x, hb_y, hb_w, hb_h, imgUrl, offsetX, offsetY);
    }

    public CustomMonster(String name, String id, int maxHealth, float hb_x, float hb_y, float hb_w, float hb_h, String imgUrl, float offsetX, float offsetY, boolean ignoreBlights) {
        super(name, id, maxHealth, hb_x, hb_y, hb_w, hb_h, imgUrl, offsetX, offsetY, ignoreBlights);
    }

    public CustomMonster(String name, String id, int maxHealth, float hb_x, float hb_y, float hb_w, float hb_h, String imgUrl) {
        super(name, id, maxHealth, hb_x, hb_y, hb_w, hb_h, imgUrl);
    }

    public void render(SpriteBatch sb) {
        if (!this.isDead && !this.escaped) {
            if (this.damageFlash) {
                ShaderHelper.setShader((SpriteBatch)sb, (ShaderHelper.Shader)ShaderHelper.Shader.WHITE_SILHOUETTE);
            }
            if (this.animation != null && this.animation.type() == AbstractAnimation.Type.SPRITE) {
                this.animation.renderSprite(sb, this.drawX + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY);
            } else if (this.atlas == null) {
                sb.setColor(this.tint.color);
                sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY, (float)this.img.getWidth() * Settings.scale, (float)this.img.getHeight() * Settings.scale, 0, 0, this.img.getWidth(), this.img.getHeight(), this.flipHorizontal, this.flipVertical);
            } else {
                this.state.update(Gdx.graphics.getDeltaTime());
                this.state.apply(this.skeleton);
                this.skeleton.updateWorldTransform();
                this.skeleton.setPosition(this.drawX + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY);
                this.skeleton.setColor(this.tint.color);
                this.skeleton.setFlip(this.flipHorizontal, this.flipVertical);
                sb.end();
                CardCrawlGame.psb.begin();
                AbstractMonster.sr.draw(CardCrawlGame.psb, this.skeleton);
                CardCrawlGame.psb.end();
                sb.begin();
                sb.setBlendFunction(770, 771);
            }
            if (this == AbstractDungeon.getCurrRoom().monsters.hoveredMonster && this.atlas == null && this.animation == null) {
                sb.setBlendFunction(770, 1);
                sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
                sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY, (float)this.img.getWidth() * Settings.scale, (float)this.img.getHeight() * Settings.scale, 0, 0, this.img.getWidth(), this.img.getHeight(), this.flipHorizontal, this.flipVertical);
                sb.setBlendFunction(770, 771);
            }
            if (this.damageFlash) {
                ShaderHelper.setShader((SpriteBatch)sb, (ShaderHelper.Shader)ShaderHelper.Shader.DEFAULT);
                --this.damageFlashFrames;
                if (this.damageFlashFrames == 0) {
                    this.damageFlash = false;
                }
            }
            if (!(this.isDying || this.isEscaping || AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT || AbstractDungeon.player.isDead || AbstractDungeon.player.hasRelic("Runic Dome") || this.intent == AbstractMonster.Intent.NONE || Settings.hideCombatElements)) {
                this.renderIntentVfxBehind(sb);
                this.renderIntent(sb);
                this.renderIntentVfxAfter(sb);
                this.renderDamageRange(sb);
            }
            this.hb.render(sb);
            this.intentHb.render(sb);
            this.healthHb.render(sb);
        }
        if (!AbstractDungeon.player.isDead) {
            this.renderHealth(sb);
            this.renderName(sb);
        }
    }

    @SpireOverride
    protected void renderDamageRange(SpriteBatch sb) {
        SpireSuper.call((Object[])new Object[]{sb});
    }

    @SpireOverride
    protected void renderIntentVfxBehind(SpriteBatch sb) {
        SpireSuper.call((Object[])new Object[]{sb});
    }

    @SpireOverride
    protected void renderIntent(SpriteBatch sb) {
        SpireSuper.call((Object[])new Object[]{sb});
    }

    @SpireOverride
    protected void renderIntentVfxAfter(SpriteBatch sb) {
        SpireSuper.call((Object[])new Object[]{sb});
    }

    @SpireOverride
    protected void renderName(SpriteBatch sb) {
        SpireSuper.call((Object[])new Object[]{sb});
    }
}

