/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.BaseMod;
import basemod.IUIElement;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Consumer;

public class ModPanel {
    public static final int BACKGROUND_LAYER = 0;
    public static final int MIDDLE_LAYER = 1;
    public static final int TEXT_LAYER = 2;
    public static final int PRIORITY_UPDATE = 0;
    public static final int DEFAULT_UPDATE = 1;
    public static final int LATE_UPDATE = 2;
    private static Texture background;
    private static Comparator<IUIElement> renderComparator;
    private static Comparator<IUIElement> updateComparator;
    private ArrayList<IUIElement> uiElementsRender;
    private ArrayList<IUIElement> uiElementsUpdate;
    private Consumer<ModPanel> createFunc;
    public InputProcessor oldInputProcessor = null;
    public boolean isUp = false;
    public HashMap<String, Integer> state;
    public boolean waitingOnEvent = false;
    private boolean created = false;

    public ModPanel() {
        this(me -> {});
    }

    public ModPanel(Consumer<ModPanel> createFunc) {
        background = ImageMaster.loadImage((String)"img/ModPanelBg.png");
        this.uiElementsRender = new ArrayList();
        this.uiElementsUpdate = new ArrayList();
        this.state = new HashMap();
        this.createFunc = createFunc;
    }

    public void onCreate() {
        if (!this.created) {
            this.createFunc.accept(this);
            this.created = true;
        }
    }

    public void addUIElement(IUIElement element) {
        this.uiElementsRender.add(element);
        Collections.sort(this.uiElementsRender, renderComparator);
        this.uiElementsUpdate.add(element);
        Collections.sort(this.uiElementsUpdate, updateComparator);
    }

    public void render(SpriteBatch sb) {
        this.renderBg(sb);
        for (IUIElement elem : this.uiElementsRender) {
            elem.render(sb);
        }
    }

    public void renderBg(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(background, (float)Settings.WIDTH / 2.0f - 682.0f, Settings.OPTION_Y - 376.0f, 682.0f, 376.0f, 1364.0f, 752.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1364, 752, false, false);
    }

    public void update() {
        for (IUIElement elem : this.uiElementsUpdate) {
            elem.update();
        }
        if (InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            BaseMod.modSettingsUp = false;
        }
        if (!BaseMod.modSettingsUp) {
            this.waitingOnEvent = false;
            Gdx.input.setInputProcessor(this.oldInputProcessor);
            CardCrawlGame.mainMenuScreen.lighten();
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            CardCrawlGame.cancelButton.hideInstantly();
            this.isUp = false;
        }
    }

    static {
        renderComparator = new Comparator<IUIElement>(){

            @Override
            public int compare(IUIElement obj0, IUIElement obj1) {
                return obj0.renderLayer() - obj1.renderLayer();
            }
        };
        updateComparator = new Comparator<IUIElement>(){

            @Override
            public int compare(IUIElement obj0, IUIElement obj1) {
                return obj0.updateOrder() - obj1.updateOrder();
            }
        };
    }
}

