/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class OrFilenameFilter
implements FilenameFilter {
    private List<FilenameFilter> filters = new LinkedList<FilenameFilter>();

    public OrFilenameFilter() {
    }

    public OrFilenameFilter(FilenameFilter ... filters) {
        for (FilenameFilter filter : filters) {
            this.addFilter(filter);
        }
    }

    public OrFilenameFilter addFilter(FilenameFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public void removeFilter(FilenameFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean accepted = false;
        if (this.filters.size() == 0) {
            accepted = true;
        } else {
            FilenameFilter filter;
            Iterator<FilenameFilter> iterator = this.filters.iterator();
            while (iterator.hasNext() && !(accepted = (filter = iterator.next()).accept(dir, name))) {
            }
        }
        return accepted;
    }
}

