/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class OrFileFilter
implements FileFilter {
    private List<FileFilter> filters = new LinkedList<FileFilter>();

    public OrFileFilter() {
    }

    public OrFileFilter(FileFilter ... filters) {
        for (FileFilter filter : filters) {
            this.addFilter(filter);
        }
    }

    public OrFileFilter addFilter(FileFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public void removeFilter(FileFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public boolean accept(File file) {
        boolean accepted = false;
        if (this.filters.size() == 0) {
            accepted = true;
        } else {
            FileFilter filter;
            Iterator<FileFilter> iterator = this.filters.iterator();
            while (iterator.hasNext() && !(accepted = (filter = iterator.next()).accept(file))) {
            }
        }
        return accepted;
    }
}

