/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.clapper.util.classutil.ClassUtilException;
import org.clapper.util.classutil.FieldInfo;
import org.clapper.util.classutil.MethodInfo;
import org.shaded.objectweb.asm.ClassReader;
import org.shaded.objectweb.asm.ClassVisitor;
import org.shaded.objectweb.asm.FieldVisitor;
import org.shaded.objectweb.asm.MethodVisitor;

public class ClassInfo
extends ClassVisitor {
    static int ASM_CR_ACCEPT_CRITERIA = 0;
    private int modifier = 0;
    private String className = null;
    private String superClassName = null;
    private String[] implementedInterfaces = null;
    private File locationFound = null;
    private Set<FieldInfo> fields = new HashSet<FieldInfo>();
    private Set<MethodInfo> methods = new HashSet<MethodInfo>();

    public ClassInfo(File classFile) throws ClassUtilException {
        super(327680);
        try {
            ClassReader cr = new ClassReader(new FileInputStream(classFile));
            cr.accept(this, ASM_CR_ACCEPT_CRITERIA);
        }
        catch (IOException ex) {
            throw new ClassUtilException("org.clapper.util.classutil.Bundle", "ClassInfo.cantReadClassFile", "Unable to load class file \"{0}\"", new Object[]{classFile.getPath()}, ex);
        }
    }

    public ClassInfo(InputStream is) throws ClassUtilException {
        super(327680);
        try {
            ClassReader cr = new ClassReader(is);
            cr.accept(this, ASM_CR_ACCEPT_CRITERIA);
        }
        catch (IOException ex) {
            throw new ClassUtilException("org.clapper.util.classutil.Bundle", "ClassInfo.cantReadClassStream", "Unable to load class from open input stream", ex);
        }
    }

    ClassInfo(String name, String superClassName, String[] interfaces, int asmAccessMask, File location) {
        super(327680);
        this.setClassFields(name, superClassName, interfaces, asmAccessMask, location);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String[] getInterfaces() {
        return this.implementedInterfaces;
    }

    public int getModifier() {
        return this.modifier;
    }

    public File getClassLocation() {
        return this.locationFound;
    }

    public Set<FieldInfo> getFields() {
        return this.fields;
    }

    public Set<MethodInfo> getMethods() {
        return this.methods;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if ((this.modifier & 1) != 0) {
            buf.append("public ");
        }
        if ((this.modifier & 0x400) != 0) {
            buf.append("abstract ");
        }
        if ((this.modifier & 0x200) != 0) {
            buf.append("interface ");
        } else {
            buf.append("class ");
        }
        buf.append(this.className);
        String sep = " ";
        if (this.implementedInterfaces.length > 0) {
            buf.append(" implements");
            for (String intf : this.implementedInterfaces) {
                buf.append(sep);
                buf.append(intf);
            }
        }
        if (this.superClassName != null && !this.superClassName.equals("java.lang.Object")) {
            buf.append(sep);
            buf.append("extends ");
            buf.append(this.superClassName);
        }
        return buf.toString();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.setClassFields(name, superName, interfaces, access, null);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String description, String signature, Object value) {
        this.fields.add(new FieldInfo(access, name, description, signature, value));
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String description, String signature, String[] exceptions) {
        this.methods.add(new MethodInfo(access, name, description, signature, exceptions));
        return null;
    }

    private String translateInternalClassName(String internalName) {
        return internalName.replaceAll("/", ".");
    }

    private void setClassFields(String name, String superClassName, String[] interfaces, int asmAccessMask, File location) {
        this.className = this.translateInternalClassName(name);
        this.locationFound = location;
        if (superClassName != null && !superClassName.equals("java/lang/Object")) {
            this.superClassName = this.translateInternalClassName(superClassName);
        }
        if (interfaces != null) {
            this.implementedInterfaces = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.implementedInterfaces[i] = this.translateInternalClassName(interfaces[i]);
            }
        }
        this.modifier = this.convertAccessMaskToModifierMask(asmAccessMask);
    }

    private int convertAccessMaskToModifierMask(int asmAccessMask) {
        int modifier = 0;
        if ((asmAccessMask & 0x10) != 0) {
            modifier |= 0x10;
        }
        if ((asmAccessMask & 0x100) != 0) {
            modifier |= 0x100;
        }
        if ((asmAccessMask & 0x200) != 0) {
            modifier |= 0x200;
        }
        if ((asmAccessMask & 0x400) != 0) {
            modifier |= 0x400;
        }
        if ((asmAccessMask & 2) != 0) {
            modifier |= 2;
        }
        if ((asmAccessMask & 4) != 0) {
            modifier |= 4;
        }
        if ((asmAccessMask & 1) != 0) {
            modifier |= 1;
        }
        if ((asmAccessMask & 8) != 0) {
            modifier |= 8;
        }
        if ((asmAccessMask & 0x800) != 0) {
            modifier |= 0x800;
        }
        if ((asmAccessMask & 0x20) != 0) {
            modifier |= 0x20;
        }
        if ((asmAccessMask & 0x80) != 0) {
            modifier |= 0x80;
        }
        if ((asmAccessMask & 0x40) != 0) {
            modifier |= 0x40;
        }
        return modifier;
    }
}

