/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;

public class PostfixPatchInfo
extends PatchInfo {
    public PostfixPatchInfo(CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        super(ctMethodToPatch, patchMethod);
    }

    @Override
    protected String debugMsg() {
        return "Adding Postfix...";
    }

    @Override
    public int patchOrdering() {
        return 2;
    }

    @Override
    public void doPatch() throws PatchingException {
        try {
            CtClass returnType = this.patchMethod.getReturnType();
            CtClass[] parameters = this.patchMethod.getParameterTypes();
            boolean returnsValue = false;
            boolean takesResultParam = false;
            if (!returnType.equals(CtPrimitiveType.voidType)) {
                returnsValue = true;
                if (Loader.DEBUG) {
                    System.out.println("      Return: " + returnType.getName());
                }
            }
            if (parameters.length >= 1 && parameters[0].equals(returnType)) {
                takesResultParam = true;
                if (Loader.DEBUG) {
                    System.out.println("      Result param: " + parameters[0].getName());
                }
            }
            String src = this.patchMethod.getDeclaringClass().getName() + "." + this.patchMethod.getName() + "(";
            if (returnsValue) {
                src = "return ($r)" + src;
            }
            if (takesResultParam) {
                src = src + "$_";
            }
            if (!Modifier.isStatic(this.ctMethodToPatch.getModifiers())) {
                if (src.charAt(src.length() - 1) != '(') {
                    src = src + ", ";
                }
                src = src + "$0";
            }
            if (src.charAt(src.length() - 1) != '(') {
                src = src + ", ";
            }
            src = src + "$$);";
            if (Loader.DEBUG) {
                System.out.println("      " + src);
            }
            this.ctMethodToPatch.insertAfter(src);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new PatchingException(e);
        }
    }
}

