/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.finders;

import com.evacipated.cardcrawl.modthespire.finders.MatchFinderExprEditor;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.patcher.Expectation;
import java.util.ArrayList;
import java.util.List;
import javassist.expr.Expr;

public class InOrderMultiFinder
extends MatchFinderExprEditor {
    private List<Integer> locations;
    private boolean foundLocation;
    private int foundMatchesIndex;
    private Matcher finalMatch;
    private List<Matcher> expectedMatches;

    public InOrderMultiFinder(List<Matcher> expectedMatches, Matcher finalMatch) {
        this.expectedMatches = expectedMatches;
        this.finalMatch = finalMatch;
        this.foundMatchesIndex = 0;
        this.foundLocation = false;
        this.locations = new ArrayList<Integer>();
    }

    private void foundFinalMatch(int lineNumber) {
        this.foundLocation = true;
        this.locations.add(lineNumber);
    }

    private boolean finalMatch() {
        return this.foundMatchesIndex >= this.expectedMatches.size();
    }

    private void foundMatch() {
        ++this.foundMatchesIndex;
    }

    private Matcher currentMatch() {
        return this.expectedMatches.get(this.foundMatchesIndex);
    }

    @Override
    protected void doMatch(Expectation expectedType, Expr toMatch) {
        if (this.finalMatch()) {
            if (this.finalMatch.getExpectation() == expectedType && this.finalMatch.match(toMatch)) {
                this.foundFinalMatch(toMatch.getLineNumber());
            }
        } else {
            Matcher current = this.currentMatch();
            if (current.getExpectation() == expectedType && current.match(toMatch)) {
                this.foundMatch();
            }
        }
    }

    @Override
    public boolean didFindLocation() {
        return this.foundLocation;
    }

    @Override
    public int[] getFoundLocations() {
        int[] asArray = new int[this.locations.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = this.locations.get(i);
        }
        return asArray;
    }
}

