/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.EnumBusterReflect;
import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.ReflectionHelper;
import com.evacipated.cardcrawl.modthespire.lib.SpireEnum;
import com.evacipated.cardcrawl.modthespire.lib.SpireInitializer;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireOverride;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatches;
import com.evacipated.cardcrawl.modthespire.lib.SpirePostfixPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePrefixPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireSuper;
import com.evacipated.cardcrawl.modthespire.patcher.ClassPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.InsertPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.InstrumentPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.LocatorInfo;
import com.evacipated.cardcrawl.modthespire.patcher.MissingParamTypesException;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfoComparator;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import com.evacipated.cardcrawl.modthespire.patcher.PostfixPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PrefixPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.RawPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.ReplacePatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.javassist.MyCodeConverter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.bytecode.DuplicateMemberException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javax.swing.JOptionPane;
import org.scannotation.AnnotationDB;

public class Patcher {
    public static Map<URL, AnnotationDB> annotationDBMap = new HashMap<URL, AnnotationDB>();
    private static Map<Class<?>, EnumBusterReflect> enumBusterMap = new HashMap();
    private static TreeSet<PatchInfo> patchInfos = new TreeSet<PatchInfo>(new PatchInfoComparator());

    public static void initializeMods(ClassLoader loader, ModInfo ... modInfos) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        for (ModInfo info : modInfos) {
            if (annotationDBMap.containsKey(info.jarURL)) {
                Set<String> initializers = annotationDBMap.get(info.jarURL).getAnnotationIndex().get(SpireInitializer.class.getName());
                if (initializers == null) continue;
                System.out.println(" - " + info.Name);
                for (String initializer : initializers) {
                    System.out.println("   - " + initializer);
                    try {
                        long startTime = System.nanoTime();
                        Method init = loader.loadClass(initializer).getDeclaredMethod("initialize", new Class[0]);
                        init.invoke(null, new Object[0]);
                        long endTime = System.nanoTime();
                        long duration = endTime - startTime;
                        System.out.println("   - " + duration / 1000000L + "ms");
                    }
                    catch (NoSuchMethodException e) {
                        System.out.println("WARNING: Unable to find method initialize() on class marked @SpireInitializer: " + initializer);
                    }
                }
                continue;
            }
            System.err.println(info.jarURL + " Not in DB map. Something is very wrong");
        }
    }

    public static List<Iterable<String>> findPatches(URL[] urls) throws IOException {
        return Patcher.findPatches(urls, null);
    }

    public static List<Iterable<String>> findPatches(ModInfo[] modInfos) throws IOException {
        URL[] urls = new URL[modInfos.length];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        return Patcher.findPatches(urls, modInfos);
    }

    public static List<Iterable<String>> findPatches(URL[] urls, ModInfo[] modInfos) throws IOException {
        ArrayList<Iterable<String>> patchSetList = new ArrayList<Iterable<String>>();
        for (int i = 0; i < urls.length; ++i) {
            if (modInfos == null || modInfos[i].MTS_Version.compareTo(Loader.MTS_VERSION) <= 0) {
                AnnotationDB db;
                if (annotationDBMap.containsKey(urls[i])) {
                    db = annotationDBMap.get(urls[i]);
                } else {
                    db = new AnnotationDB();
                    annotationDBMap.put(urls[i], db);
                }
                db.scanArchives(urls[i]);
                patchSetList.add(db.getAnnotationIndex().get(SpirePatch.class.getName()));
                patchSetList.add(db.getAnnotationIndex().get(SpirePatches.class.getName()));
                continue;
            }
            String str = "ERROR: " + modInfos[i].Name + " requires ModTheSpire v" + modInfos[i].MTS_Version + " or greater!";
            System.out.println(str);
            JOptionPane.showMessageDialog(null, str);
        }
        return patchSetList;
    }

    public static HashSet<CtClass> patchEnums(ClassLoader loader, ClassPool pool, ModInfo[] modInfos) throws IOException, ClassNotFoundException, NotFoundException, CannotCompileException {
        URL[] urls = new URL[modInfos.length];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        return Patcher.patchEnums(loader, pool, urls);
    }

    public static HashSet<CtClass> patchEnums(ClassLoader loader, ClassPool pool, URL ... urls) throws IOException, ClassNotFoundException, NotFoundException, CannotCompileException {
        HashSet<CtClass> ctClasses = new HashSet<CtClass>();
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.scanArchives(urls);
        Set<String> annotations = db.getAnnotationIndex().get(SpireEnum.class.getName());
        if (annotations == null) {
            return ctClasses;
        }
        boolean hasPrintedWarning = false;
        for (String s : annotations) {
            Class<?> cls = loader.loadClass(s);
            for (Field field : cls.getDeclaredFields()) {
                SpireEnum spireEnum = field.getDeclaredAnnotation(SpireEnum.class);
                if (spireEnum == null) continue;
                String enumName = field.getName();
                if (!spireEnum.name().isEmpty()) {
                    enumName = spireEnum.name();
                }
                try {
                    CtClass ctClass = pool.get(field.getType().getName());
                    CtField f = new CtField(ctClass, enumName, ctClass);
                    f.setModifiers(16409);
                    ctClass.addField(f);
                    ctClasses.add(ctClass);
                }
                catch (DuplicateMemberException ignore) {
                    if (!Loader.DEBUG && !hasPrintedWarning) {
                        hasPrintedWarning = true;
                        System.out.println();
                    }
                    System.out.println(String.format("Warning: @SpireEnum %s %s is already defined.", field.getType().getName(), enumName));
                }
            }
        }
        return ctClasses;
    }

    public static void bustEnums(ClassLoader loader, ModInfo[] modInfos) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        URL[] urls = new URL[modInfos.length];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        Patcher.bustEnums(loader, urls);
    }

    public static void bustEnums(ClassLoader loader, URL ... urls) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.scanArchives(urls);
        Set<String> annotations = db.getAnnotationIndex().get(SpireEnum.class.getName());
        if (annotations == null) {
            return;
        }
        for (String s : annotations) {
            Class<?> cls = loader.loadClass(s);
            for (Field field : cls.getDeclaredFields()) {
                EnumBusterReflect buster;
                SpireEnum spireEnum = field.getDeclaredAnnotation(SpireEnum.class);
                if (spireEnum == null) continue;
                String enumName = field.getName();
                if (!spireEnum.name().isEmpty()) {
                    enumName = spireEnum.name();
                }
                if (enumBusterMap.containsKey(field.getType())) {
                    buster = enumBusterMap.get(field.getType());
                } else {
                    buster = new EnumBusterReflect(loader, field.getType());
                    enumBusterMap.put(field.getType(), buster);
                }
                Enum<?> enumValue = buster.make(enumName);
                buster.addByValue(enumValue);
                try {
                    Field constantField = field.getType().getField(enumName);
                    ReflectionHelper.setStaticFinalField(constantField, enumValue);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                field.setAccessible(true);
                field.set(null, enumValue);
            }
        }
    }

    public static void finalizePatches(ClassLoader loader) throws Exception {
        System.out.printf("Injecting patches...", new Object[0]);
        if (Loader.DEBUG) {
            System.out.println();
            System.out.println();
        }
        for (PatchInfo p : patchInfos) {
            if (Loader.DEBUG) {
                p.debugPrint();
            }
            try {
                p.doPatch();
            }
            catch (Exception e) {
                if (!Loader.DEBUG) {
                    System.out.println();
                    p.debugPrint();
                }
                throw e;
            }
            if (!Loader.DEBUG) continue;
            System.out.println();
        }
        patchInfos.clear();
        System.out.println("Done.");
    }

    public static void compilePatches(ClassLoader loader, SortedMap<String, CtClass> ctClasses) throws CannotCompileException {
        System.out.printf("Compiling patched classes...", new Object[0]);
        if (Loader.DEBUG) {
            System.out.println();
        }
        for (Map.Entry<String, CtClass> cls : ctClasses.entrySet()) {
            if (Loader.DEBUG) {
                System.out.println("  " + cls.getValue().getName());
            }
            cls.getValue().toClass(loader, null);
        }
        System.out.println("Done.");
    }

    public static HashSet<CtClass> injectPatches(ClassLoader loader, ClassPool pool, List<Iterable<String>> class_names) throws Exception {
        HashSet<CtClass> ctClasses = new HashSet<CtClass>();
        for (Iterable<String> it : class_names) {
            HashSet<CtClass> tmp = Patcher.injectPatches(loader, pool, it);
            if (tmp != null) {
                ctClasses.addAll(tmp);
            }
            PatchInfo.nextMod();
        }
        return ctClasses;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashSet<CtClass> injectPatches(ClassLoader loader, ClassPool pool, Iterable<String> class_names) throws Exception {
        if (class_names == null) {
            return null;
        }
        HashSet<CtClass> ctClasses = new HashSet<CtClass>();
        Iterator<String> iterator = class_names.iterator();
        block4: while (iterator.hasNext()) {
            String cls_name = iterator.next();
            CtClass ctPatchClass = pool.get(cls_name);
            SpirePatch[] patchArr = null;
            SpirePatches patches = (SpirePatches)ctPatchClass.getAnnotation(SpirePatches.class);
            if (patches != null) {
                patchArr = patches.value();
            } else {
                SpirePatch patch = (SpirePatch)ctPatchClass.getAnnotation(SpirePatch.class);
                if (patch != null) {
                    patchArr = new SpirePatch[]{patch};
                }
            }
            SpirePatch[] spirePatchArray = patchArr;
            int n = spirePatchArray.length;
            int n2 = 0;
            while (true) {
                block50: {
                    CtBehavior ctMethodToPatch;
                    CtClass ctClsToPatch;
                    block51: {
                        SpirePatch patch;
                        block49: {
                            if (n2 >= n) continue block4;
                            patch = spirePatchArray[n2];
                            ctClsToPatch = null;
                            try {
                                if (!patch.clz().equals(Void.TYPE)) {
                                    ctClsToPatch = pool.get(patch.clz().getName());
                                    break block49;
                                }
                                if (patch.cls().isEmpty()) break block49;
                                ctClsToPatch = pool.get(patch.cls());
                            }
                            catch (NotFoundException e) {
                                if (!patch.optional()) {
                                    throw new PatchingException(ctPatchClass.getName(), e);
                                }
                                break block50;
                            }
                        }
                        if (ctClsToPatch == null) {
                            throw new PatchingException(ctPatchClass, "No class defined to patch. Must define either clz or cls in @SpirePatch.");
                        }
                        ctMethodToPatch = null;
                        try {
                            CtClass[] ctParamTypes = Patcher.patchParamTypez(pool, patch);
                            if (ctParamTypes == null) {
                                ctParamTypes = Patcher.patchParamTypes(pool, patch);
                            }
                            if (patch.method().equals("<ctor>")) {
                                if (ctParamTypes == null) {
                                    CtConstructor[] constructors = ctClsToPatch.getDeclaredConstructors();
                                    if (constructors.length != 1) {
                                        throw new MissingParamTypesException(ctPatchClass, patch);
                                    }
                                    ctMethodToPatch = constructors[0];
                                    break block51;
                                } else {
                                    ctMethodToPatch = ctClsToPatch.getDeclaredConstructor(ctParamTypes);
                                }
                                break block51;
                            }
                            if (patch.method().equals("<staticinit>")) {
                                ctMethodToPatch = ctClsToPatch.getClassInitializer();
                                if (ctMethodToPatch == null) {
                                    System.out.println("No class initializer, making one");
                                    ctMethodToPatch = ctClsToPatch.makeClassInitializer();
                                }
                                break block51;
                            }
                            if (patch.method().equals("<class>")) {
                                patchInfos.add(new ClassPatchInfo(ctClsToPatch, ctPatchClass));
                                ctClasses.add(ctClsToPatch);
                                ctClasses.add(ctPatchClass);
                                break block51;
                            }
                            if (ctParamTypes == null) {
                                CtMethod[] methods = ctClsToPatch.getDeclaredMethods(patch.method());
                                if (methods.length == 1) {
                                    ctMethodToPatch = methods[0];
                                    break block51;
                                } else {
                                    if (methods.length == 0) {
                                        throw new NoSuchMethodException(String.format("Patch %s:\nNo method named [%s] found on\nclass [%s]", ctPatchClass.getName(), patch.method(), Patcher.patchClassName(patch)));
                                    }
                                    throw new MissingParamTypesException(ctPatchClass, patch);
                                }
                            }
                            ctMethodToPatch = ctClsToPatch.getDeclaredMethod(patch.method(), ctParamTypes);
                        }
                        catch (NotFoundException e) {
                            throw new NoSuchMethodException(String.format("Patch %s:\nNo method [%s(%s)] found on\nclass [%s]", ctPatchClass.getName(), patch.method(), Patcher.patchParamTypesString(patch), Patcher.patchClassName(patch)));
                        }
                    }
                    if (ctMethodToPatch != null) {
                        for (CtMethod m : ctPatchClass.getDeclaredMethods()) {
                            void var19_23;
                            Object var19_24 = null;
                            if (m.getName().equals("Prefix") || m.hasAnnotation(SpirePrefixPatch.class)) {
                                PrefixPatchInfo prefixPatchInfo = new PrefixPatchInfo(ctMethodToPatch, m);
                            } else if (m.getName().equals("Postfix") || m.hasAnnotation(SpirePostfixPatch.class)) {
                                PostfixPatchInfo postfixPatchInfo = new PostfixPatchInfo(ctMethodToPatch, m);
                            } else {
                                if (m.getName().equals("Locator")) continue;
                                if (m.getName().equals("Insert") || m.hasAnnotation(SpireInsertPatch.class)) {
                                    SpireInsertPatch insertPatch = (SpireInsertPatch)m.getAnnotation(SpireInsertPatch.class);
                                    LocatorInfo locatorInfo = null;
                                    if (insertPatch != null && !insertPatch.locator().equals(SpireInsertPatch.NONE.class)) {
                                        locatorInfo = new LocatorInfo(ctMethodToPatch, loader.loadClass(insertPatch.locator().getName()));
                                    }
                                    if (!Patcher.isInsertPatchValid(insertPatch, locatorInfo)) {
                                        throw new PatchingException(m, "SpireInsertPatch missing line number! Must specify either loc, rloc, locs, rlocs, or a Locator");
                                    }
                                    ArrayList<InsertPatchInfo.LineNumberAndPatchType> locs = new ArrayList<InsertPatchInfo.LineNumberAndPatchType>();
                                    if (locatorInfo != null) {
                                        int[] abs_locs = locatorInfo.findLines();
                                        if (abs_locs.length < 1) {
                                            throw new PatchingException(m, "Locator must locate at least 1 line!");
                                        }
                                        for (int i = 0; i < abs_locs.length; ++i) {
                                            locs.add(new InsertPatchInfo.LineNumberAndPatchType(abs_locs[i]));
                                        }
                                    }
                                    if (insertPatch != null) {
                                        int i;
                                        if (insertPatch.loc() >= 0) {
                                            locs.add(new InsertPatchInfo.LineNumberAndPatchType(insertPatch.loc()));
                                        }
                                        if (insertPatch.rloc() >= 0) {
                                            locs.add(new InsertPatchInfo.LineNumberAndPatchType(ctMethodToPatch.getMethodInfo().getLineNumber(0) + insertPatch.rloc(), insertPatch.rloc()));
                                        }
                                        for (i = 0; i < insertPatch.locs().length; ++i) {
                                            locs.add(new InsertPatchInfo.LineNumberAndPatchType(insertPatch.locs()[i]));
                                        }
                                        for (i = 0; i < insertPatch.rlocs().length; ++i) {
                                            locs.add(new InsertPatchInfo.LineNumberAndPatchType(ctMethodToPatch.getMethodInfo().getLineNumber(0) + insertPatch.rlocs()[i], insertPatch.rlocs()[i]));
                                        }
                                    }
                                    InsertPatchInfo insertPatchInfo = new InsertPatchInfo(insertPatch, locs, ctMethodToPatch, m);
                                } else if (m.getName().equals("Instrument")) {
                                    InstrumentPatchInfo instrumentPatchInfo = new InstrumentPatchInfo(ctMethodToPatch, loader.loadClass(cls_name).getDeclaredMethod(m.getName(), new Class[0]));
                                } else if (m.getName().equals("Replace")) {
                                    ReplacePatchInfo replacePatchInfo = new ReplacePatchInfo(ctMethodToPatch, m);
                                } else if (m.getName().equals("Raw")) {
                                    RawPatchInfo rawPatchInfo = new RawPatchInfo(ctMethodToPatch, Patcher.findRawMethod(loader.loadClass(cls_name), m.getName()));
                                }
                            }
                            if (var19_23 == null) continue;
                            patchInfos.add((PatchInfo)var19_23);
                        }
                        ctClasses.add(ctClsToPatch);
                    }
                }
                ++n2;
            }
            break;
        }
        return ctClasses;
    }

    private static boolean isInsertPatchValid(SpireInsertPatch insertPatch, LocatorInfo locatorInfo) {
        if (locatorInfo != null) {
            return true;
        }
        return insertPatch != null && (insertPatch.loc() != -1 || insertPatch.rloc() != -1 || insertPatch.locs().length != 0 || insertPatch.rlocs().length != 0);
    }

    private static CtClass[] patchParamTypes(ClassPool pool, SpirePatch patch) throws NotFoundException {
        Object[] def = new String[]{"DEFAULT"};
        if (Arrays.equals(patch.paramtypes(), def)) {
            return null;
        }
        return pool.get(patch.paramtypes());
    }

    private static CtClass[] patchParamTypez(ClassPool pool, SpirePatch patch) throws NotFoundException {
        if (patch.paramtypez().length == 1 && Void.TYPE.equals(patch.paramtypez()[0])) {
            return null;
        }
        String[] names = new String[patch.paramtypez().length];
        for (int i = 0; i < patch.paramtypez().length; ++i) {
            names[i] = patch.paramtypez()[i].getName();
        }
        return pool.get(names);
    }

    private static Method findRawMethod(Class<?> cls, String name) throws NoSuchMethodException {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || m.getParameterCount() != 1) continue;
            return m;
        }
        throw new NoSuchMethodException();
    }

    private static String patchParamTypesString(SpirePatch patch) {
        if (patch.paramtypez().length == 1 && Void.TYPE.equals(patch.paramtypez()[0])) {
            Object[] def = new String[]{"DEFAULT"};
            if (Arrays.equals(patch.paramtypes(), def)) {
                return "";
            }
            return String.join((CharSequence)", ", patch.paramtypes());
        }
        CharSequence[] tmp = new String[patch.paramtypez().length];
        for (int i = 0; i < patch.paramtypez().length; ++i) {
            tmp[i] = patch.paramtypez()[i].getName();
        }
        return String.join((CharSequence)", ", tmp);
    }

    private static String patchClassName(SpirePatch patch) {
        if (patch.clz().equals(Void.TYPE)) {
            return patch.cls();
        }
        return patch.clz().getName();
    }

    static HashSet<CtClass> patchOverrides(ClassLoader loader, ClassPool pool, ModInfo[] modInfos) throws PatchingException {
        System.out.println("Patching Overrides...");
        MyCodeConverter.reset();
        HashSet<CtClass> ctClasses = new HashSet<CtClass>();
        for (AnnotationDB db : annotationDBMap.values()) {
            Set<String> classNames = db.getAnnotationIndex().get(SpireOverride.class.getName());
            if (classNames == null) continue;
            for (String className : classNames) {
                if (Loader.DEBUG) {
                    System.out.println("Class: [" + className + "]");
                }
                try {
                    CtClass cc = pool.get(className);
                    for (final CtMethod ctMethod : cc.getDeclaredMethods()) {
                        if (!ctMethod.hasAnnotation(SpireOverride.class)) continue;
                        CtMethod superMethod = Patcher.findSuperMethod(ctMethod);
                        if (superMethod == null) {
                            throw new PatchingException(ctMethod, "Has no matching method signature in any superclass");
                        }
                        if (Loader.DEBUG) {
                            System.out.println(" - Overriding [" + superMethod.getLongName() + "]");
                            System.out.println("      Fixing invocations in superclass " + superMethod.getDeclaringClass().getSimpleName() + "...");
                        }
                        MyCodeConverter codeConverter = new MyCodeConverter();
                        codeConverter.redirectSpecialMethodCall(superMethod);
                        superMethod.getDeclaringClass().instrument(codeConverter);
                        if (Loader.DEBUG) {
                            System.out.println("      Replacing SpireSuper calls...");
                        }
                        ExprEditor exprEditor = new ExprEditor(){

                            @Override
                            public void edit(MethodCall m) throws CannotCompileException {
                                try {
                                    if (m.getClassName().equals(SpireSuper.class.getName())) {
                                        if (Loader.DEBUG) {
                                            System.out.println("        @ " + m.getLineNumber());
                                        }
                                        String src = " { ";
                                        if (!ctMethod.getReturnType().equals(CtClass.voidType)) {
                                            src = src + "$_ = ";
                                        }
                                        src = src + "super." + ctMethod.getName() + "(";
                                        for (int i = 0; i < ctMethod.getParameterTypes().length; ++i) {
                                            if (i > 0) {
                                                src = src + ", ";
                                            }
                                            src = src + Patcher.makeObjectCastedString(ctMethod.getParameterTypes()[i], "$1[" + i + "]");
                                        }
                                        src = src + ");\n";
                                        if (ctMethod.getReturnType().equals(CtClass.voidType)) {
                                            src = src + "$_ = null;";
                                        }
                                        src = src + " }";
                                        if (Loader.DEBUG) {
                                            System.out.println(src);
                                        }
                                        m.replace(src);
                                    }
                                }
                                catch (NotFoundException e) {
                                    throw new CannotCompileException(e);
                                }
                            }
                        };
                        ctMethod.instrument(exprEditor);
                        ctClasses.add(superMethod.getDeclaringClass());
                        ctClasses.add(ctMethod.getDeclaringClass());
                    }
                }
                catch (CannotCompileException | NotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ctClasses;
    }

    private static CtMethod findSuperMethod(CtMethod ctMethod) throws NotFoundException {
        for (CtClass superclass = ctMethod.getDeclaringClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            try {
                CtMethod superMethod = superclass.getDeclaredMethod(ctMethod.getName(), ctMethod.getParameterTypes());
                if (!ctMethod.getReturnType().equals(superMethod.getReturnType())) continue;
                return superMethod;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String makeObjectCastedString(CtClass ctType, String value) {
        String typename = ctType.getName();
        String extra = "";
        if (ctType.isPrimitive()) {
            typename = ctType.equals(CtPrimitiveType.intType) ? "Integer" : (ctType.equals(CtPrimitiveType.charType) ? "Character" : typename.substring(0, 1).toUpperCase() + typename.substring(1));
            extra = "." + ctType.getName() + "Value()";
        }
        return "((" + typename + ") " + value + ")" + extra;
    }
}

