/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.CyclicDependencyException;
import com.evacipated.cardcrawl.modthespire.GraphTS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphTS<T> {
    private List<Vertex> vertexList = new ArrayList<Vertex>();
    private List<List<Boolean>> matrix = new ArrayList<List<Boolean>>();
    public List<T> sortedArray = new ArrayList<T>();

    public void addVertex(T v) {
        this.vertexList.add(new Vertex(v));
        ArrayList tmp = new ArrayList();
        this.matrix.add(tmp);
        for (List<Boolean> row : this.matrix) {
            for (int i = row.size(); i < this.vertexList.size(); ++i) {
                row.add(false);
            }
        }
    }

    public void addEdge(int start, int end) {
        this.matrix.get(start).set(end, true);
    }

    public void displayVertex(int idx) {
        System.out.print(this.vertexList.get((int)idx).value);
    }

    public void tsort() throws CyclicDependencyException {
        this.sortedArray.clear();
        while (this.vertexList.size() > 0) {
            int currentVertex = this.noSuccessors();
            if (currentVertex == -1) {
                throw new CyclicDependencyException();
            }
            this.sortedArray.add(this.vertexList.get((int)currentVertex).value);
            this.deleteVertex(currentVertex);
        }
        Collections.reverse(this.sortedArray);
    }

    public void tsortStable() {
        this.sortedArray.clear();
        for (Vertex v : this.vertexList) {
            this.sortedArray.add(v.value);
        }
        int n = this.sortedArray.size();
        Dependencies depends = new Dependencies();
        boolean restart = false;
        block1: do {
            restart = false;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!depends.doesXHaveDirectDependencyOnY(this.sortedArray.get(j), this.sortedArray.get(i))) continue;
                    boolean iOnJ = depends.doesXHaveTransientDependencyOnY(this.sortedArray.get(j), this.sortedArray.get(i));
                    boolean jOnI = depends.doesXHaveTransientDependencyOnY(this.sortedArray.get(i), this.sortedArray.get(j));
                    if (jOnI && iOnJ) continue;
                    T t = this.sortedArray.get(i);
                    List<Boolean> children = this.matrix.get(i);
                    this.sortedArray.remove(i);
                    this.matrix.remove(i);
                    this.sortedArray.add(j, t);
                    this.matrix.add(j, children);
                    restart = true;
                    break;
                }
                if (restart) continue block1;
            }
        } while (restart);
    }

    private int noSuccessors() {
        for (int row = 0; row < this.vertexList.size(); ++row) {
            boolean isEdge = false;
            for (int col = 0; col < this.vertexList.size(); ++col) {
                if (!this.matrix.get(row).get(col).booleanValue()) continue;
                isEdge = true;
                break;
            }
            if (isEdge) continue;
            return row;
        }
        return -1;
    }

    public void deleteVertex(int delVert) {
        this.vertexList.remove(delVert);
        for (List<Boolean> row : this.matrix) {
            row.remove(delVert);
        }
        this.matrix.remove(delVert);
    }

    private class Dependencies {
        private Map<T, com.evacipated.cardcrawl.modthespire.GraphTS$Dependencies.Node> Nodes = new HashMap();
        private Set<T> visitedNodes = new HashSet();

        Dependencies() {
            for (int i = 0; i < GraphTS.this.vertexList.size(); ++i) {
                Node node = (Node)this.Nodes.get(((Vertex)((GraphTS)GraphTS.this).vertexList.get((int)i)).value);
                if (node == null) {
                    node = new Node();
                    this.Nodes.put(((Vertex)((GraphTS)GraphTS.this).vertexList.get((int)i)).value, (com.evacipated.cardcrawl.modthespire.GraphTS$Dependencies.Node)node);
                }
                for (int j = 0; j < GraphTS.this.vertexList.size(); ++j) {
                    if (i == j || !((Boolean)((List)GraphTS.this.matrix.get(j)).get(i)).booleanValue()) continue;
                    node.children.add(((Vertex)((GraphTS)GraphTS.this).vertexList.get((int)j)).value);
                }
            }
        }

        boolean doesXHaveDirectDependencyOnY(T x, T y) {
            Node node = (Node)this.Nodes.get(x);
            return node != null && node.children.contains(y);
        }

        boolean doesXHaveTransientDependencyOnY(T x, T y) {
            if (!this.visitedNodes.add(x)) {
                return false;
            }
            if (this.doesXHaveDirectDependencyOnY(x, y)) {
                return true;
            }
            Node node = (Node)this.Nodes.get(x);
            if (node != null) {
                for (Object t : node.children) {
                    if (!this.doesXHaveTransientDependencyOnY(t, y)) continue;
                    return true;
                }
            }
            return false;
        }

        class Node {
            List<T> children = new ArrayList();

            Node() {
            }
        }
    }

    class Vertex {
        T value;

        Vertex(T v) {
            this.value = v;
        }
    }
}

