/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Animation;
import com.brashmonkey.spriter.Curve;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.Mainline;
import com.brashmonkey.spriter.SpriterException;
import com.brashmonkey.spriter.Timeline;

public class TweenedAnimation
extends Animation {
    public float weight = 0.5f;
    public float spriteThreshold = 0.5f;
    public final Curve curve;
    public final Entity entity;
    private Animation anim1;
    private Animation anim2;
    public Animation baseAnimation;
    Mainline.Key.BoneRef base = null;
    public boolean tweenSprites = false;

    public TweenedAnimation(Entity entity) {
        super(-1, "__interpolatedAnimation__", 0, true);
        this.entity = entity;
        this.curve = new Curve();
        this.setUpTimelines();
    }

    public Mainline.Key getCurrentKey() {
        return this.currentKey;
    }

    @Override
    public void update(int time, Timeline.Key.Bone root) {
        this.currentKey = this.onFirstMainLine() ? this.anim1.currentKey : this.anim2.currentKey;
        for (Timeline.Key timelineKey : this.unmappedTweenedKeys) {
            timelineKey.active = false;
        }
        if (this.base != null) {
            Animation currentAnim;
            Animation animation = currentAnim = this.onFirstMainLine() ? this.anim1 : this.anim2;
            Animation baseAnim = this.baseAnimation == null ? (this.onFirstMainLine() ? this.anim1 : this.anim2) : this.baseAnimation;
            for (Mainline.Key.BoneRef ref : this.currentKey.boneRefs) {
                Timeline timeline = baseAnim.getSimilarTimeline(currentAnim.getTimeline(ref.timeline));
                if (timeline == null) continue;
                Timeline.Key key = baseAnim.tweenedKeys[timeline.id];
                Timeline.Key mappedKey = baseAnim.unmappedTweenedKeys[timeline.id];
                this.tweenedKeys[ref.timeline].active = key.active;
                this.tweenedKeys[ref.timeline].object().set(key.object());
                this.unmappedTweenedKeys[ref.timeline].active = mappedKey.active;
                this.unmapTimelineObject(ref.timeline, false, ref.parent != null ? this.unmappedTweenedKeys[ref.parent.timeline].object() : root);
            }
        }
        this.tweenBoneRefs(this.base, root);
        for (Mainline.Key.ObjectRef ref : this.currentKey.objectRefs) {
            this.update(ref, root, 0);
        }
    }

    private void tweenBoneRefs(Mainline.Key.BoneRef base, Timeline.Key.Bone root) {
        int startIndex = base == null ? -1 : base.id - 1;
        int length = this.currentKey.boneRefs.size();
        for (int i = startIndex + 1; i < length; ++i) {
            Mainline.Key.BoneRef ref = this.currentKey.boneRefs.get(i);
            if (base == ref || ref.parent == base) {
                this.update(ref, root, 0);
            }
            if (base != ref.parent) continue;
            this.tweenBoneRefs(ref, root);
        }
    }

    @Override
    protected void update(Mainline.Key.BoneRef ref, Timeline.Key.Bone root, int time) {
        boolean isObject = ref instanceof Mainline.Key.ObjectRef;
        Timeline.Key.Object bone1 = null;
        Timeline.Key.Object bone2 = null;
        Timeline.Key.Object tweenTarget = null;
        Timeline t1 = this.onFirstMainLine() ? this.anim1.getTimeline(ref.timeline) : this.anim1.getSimilarTimeline(this.anim2.getTimeline(ref.timeline));
        Timeline t2 = this.onFirstMainLine() ? this.anim2.getSimilarTimeline(t1) : this.anim2.getTimeline(ref.timeline);
        Timeline targetTimeline = super.getTimeline(this.onFirstMainLine() ? t1.id : t2.id);
        if (t1 != null) {
            bone1 = this.anim1.tweenedKeys[t1.id].object();
        }
        if (t2 != null) {
            bone2 = this.anim2.tweenedKeys[t2.id].object();
        }
        if (targetTimeline != null) {
            tweenTarget = this.tweenedKeys[targetTimeline.id].object();
        }
        if (isObject && (t2 == null || !this.tweenSprites)) {
            if (!this.onFirstMainLine()) {
                bone1 = bone2;
            } else {
                bone2 = bone1;
            }
        }
        if (bone2 != null && tweenTarget != null && bone1 != null) {
            if (isObject) {
                this.tweenObject(bone1, bone2, tweenTarget, this.weight, this.curve);
            } else {
                this.tweenBone(bone1, bone2, tweenTarget, this.weight, this.curve);
            }
            this.unmappedTweenedKeys[targetTimeline.id].active = true;
        }
        if (this.unmappedTweenedKeys[ref.timeline].active) {
            this.unmapTimelineObject(targetTimeline.id, isObject, ref.parent != null ? this.unmappedTweenedKeys[ref.parent.timeline].object() : root);
        }
    }

    private void tweenBone(Timeline.Key.Bone bone1, Timeline.Key.Bone bone2, Timeline.Key.Bone target, float t, Curve curve) {
        target.angle = curve.tweenAngle(bone1.angle, bone2.angle, t);
        curve.tweenPoint(bone1.position, bone2.position, t, target.position);
        curve.tweenPoint(bone1.scale, bone2.scale, t, target.scale);
        curve.tweenPoint(bone1.pivot, bone2.pivot, t, target.pivot);
    }

    private void tweenObject(Timeline.Key.Object object1, Timeline.Key.Object object2, Timeline.Key.Object target, float t, Curve curve) {
        this.tweenBone(object1, object2, target, t, curve);
        target.alpha = curve.tweenAngle(object1.alpha, object2.alpha, t);
        target.ref.set(object1.ref);
    }

    public boolean onFirstMainLine() {
        return this.weight < this.spriteThreshold;
    }

    private void setUpTimelines() {
        Animation maxAnim = this.entity.getAnimationWithMostTimelines();
        int max = maxAnim.timelines();
        for (int i = 0; i < max; ++i) {
            Timeline t = new Timeline(i, maxAnim.getTimeline((int)i).name, maxAnim.getTimeline((int)i).objectInfo);
            this.addTimeline(t);
        }
        this.prepare();
    }

    public void setAnimations(Animation animation1, Animation animation2) {
        boolean areInterpolated;
        boolean bl = areInterpolated = animation1 instanceof TweenedAnimation || animation2 instanceof TweenedAnimation;
        if (animation1 == this.anim1 && animation2 == this.anim2) {
            return;
        }
        if (!(this.entity.containsAnimation(animation1) && this.entity.containsAnimation(animation2) || areInterpolated)) {
            throw new SpriterException("Both animations have to be part of the same entity!");
        }
        this.anim1 = animation1;
        this.anim2 = animation2;
    }

    public Animation getFirstAnimation() {
        return this.anim1;
    }

    public Animation getSecondAnimation() {
        return this.anim2;
    }
}

