/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Data;
import com.brashmonkey.spriter.Drawer;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.Loader;
import com.brashmonkey.spriter.Player;
import com.brashmonkey.spriter.SCMLReader;
import com.brashmonkey.spriter.SpriterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Spriter {
    private static Object[] loaderDependencies = new Object[1];
    private static Object[] drawerDependencies = new Object[1];
    private static Class<?>[] loaderTypes = new Class[1];
    private static Class<?>[] drawerTypes = new Class[1];
    private static Class<? extends Loader> loaderClass;
    private static final HashMap<String, Data> loadedData;
    private static final List<Player> players;
    private static final List<Loader> loaders;
    private static Drawer<?> drawer;
    private static final HashMap<Entity, Loader> entityToLoader;
    private static boolean initialized;

    public static void setLoaderDependencies(Object ... loaderDependencies) {
        if (loaderDependencies == null) {
            return;
        }
        Spriter.loaderDependencies = new Object[loaderDependencies.length + 1];
        System.arraycopy(loaderDependencies, 0, Spriter.loaderDependencies, 1, loaderDependencies.length);
        loaderTypes = new Class[loaderDependencies.length + 1];
        Spriter.loaderTypes[0] = Data.class;
        for (int i = 0; i < loaderDependencies.length; ++i) {
            Spriter.loaderTypes[i + 1] = loaderDependencies[i].getClass();
        }
    }

    public static void setDrawerDependencies(Object ... drawerDependencies) {
        if (drawerDependencies == null) {
            return;
        }
        Spriter.drawerDependencies = new Object[drawerDependencies.length + 1];
        Spriter.drawerDependencies[0] = null;
        System.arraycopy(drawerDependencies, 0, Spriter.drawerDependencies, 1, drawerDependencies.length);
        drawerTypes = new Class[drawerDependencies.length + 1];
        Spriter.drawerTypes[0] = Loader.class;
        for (int i = 0; i < drawerDependencies.length; ++i) {
            if (drawerDependencies[i] == null) continue;
            Spriter.drawerTypes[i + 1] = drawerDependencies[i].getClass();
        }
    }

    public static void init(Class<? extends Loader> loaderClass, Class<? extends Drawer> drawerClass) {
        Spriter.loaderClass = loaderClass;
        try {
            drawer = drawerClass.getDeclaredConstructor(drawerTypes).newInstance(drawerDependencies);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        initialized = drawer != null;
    }

    public static void load(String scmlFile) {
        Spriter.load(new File(scmlFile));
    }

    public static void load(File scmlFile) {
        try {
            Spriter.load(new FileInputStream(scmlFile), scmlFile.getPath().replaceAll("\\\\", "/"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void load(InputStream stream, String scmlFile) {
        SCMLReader reader = new SCMLReader(stream);
        Data data = reader.data;
        loadedData.put(scmlFile, data);
        Spriter.loaderDependencies[0] = data;
        try {
            Loader loader = loaderClass.getDeclaredConstructor(loaderTypes).newInstance(loaderDependencies);
            loader.load(new File(scmlFile));
            loaders.add(loader);
            for (Entity entity : data.entities) {
                entityToLoader.put(entity, loader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Player newPlayer(String scmlFile, int entityIndex) {
        return Spriter.newPlayer(scmlFile, entityIndex, Player.class);
    }

    public static Player newPlayer(String scmlFile, int entityIndex, Class<? extends Player> playerClass) {
        if (!loadedData.containsKey(scmlFile)) {
            throw new SpriterException("You have to load \"" + scmlFile + "\" before using it!");
        }
        try {
            Player player = playerClass.getDeclaredConstructor(Entity.class).newInstance(loadedData.get(scmlFile).getEntity(entityIndex));
            players.add(player);
            return player;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Player newPlayer(String scmlFile, String entityName) {
        if (!loadedData.containsKey(scmlFile)) {
            throw new SpriterException("You have to load \"" + scmlFile + "\" before using it!");
        }
        return Spriter.newPlayer(scmlFile, loadedData.get(scmlFile).getEntityIndex(entityName));
    }

    public static Loader<?> getLoader(String scmlFile) {
        return entityToLoader.get(Spriter.getData(scmlFile).getEntity(0));
    }

    public static void updateAndDraw() {
        if (!initialized) {
            throw new SpriterException("Call init() before updating!");
        }
        for (Player player : players) {
            player.update();
            Spriter.drawer.loader = entityToLoader.get(player.getEntity());
            drawer.draw(player);
        }
    }

    public static void update() {
        if (!initialized) {
            throw new SpriterException("Call init() before updating!");
        }
        for (Player player : players) {
            player.update();
        }
    }

    public static void draw() {
        if (!initialized) {
            throw new SpriterException("Call init() before drawing!");
        }
        for (Player player : players) {
            Spriter.drawer.loader = entityToLoader.get(player.getEntity());
            drawer.draw(player);
        }
    }

    public static Drawer drawer() {
        return drawer;
    }

    public static Data getData(String fileName) {
        return loadedData.get(fileName);
    }

    public static int players() {
        return players.size();
    }

    public static void dispose() {
        drawer = null;
        drawerDependencies = new Object[1];
        drawerTypes = new Class[1];
        Spriter.drawerTypes[0] = Loader.class;
        entityToLoader.clear();
        for (Loader loader : loaders) {
            loader.dispose();
        }
        loaders.clear();
        loadedData.clear();
        loaderClass = null;
        loaderTypes = new Class[1];
        Spriter.loaderTypes[0] = Data.class;
        loaderDependencies = new Object[1];
        players.clear();
        initialized = false;
    }

    static {
        Spriter.loaderTypes[0] = Data.class;
        Spriter.drawerTypes[0] = Loader.class;
        loadedData = new HashMap();
        players = new ArrayList<Player>();
        loaders = new ArrayList<Loader>();
        entityToLoader = new HashMap();
        initialized = false;
    }
}

