/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Data;
import com.brashmonkey.spriter.File;
import com.brashmonkey.spriter.FileReference;
import com.brashmonkey.spriter.Folder;
import java.util.HashMap;

public abstract class Loader<R> {
    protected final HashMap<FileReference, R> resources;
    protected Data data;
    protected String root = "";
    private boolean disposed;

    public Loader(Data data) {
        this.data = data;
        this.resources = new HashMap(100);
    }

    protected abstract R loadResource(FileReference var1);

    protected void finishLoading() {
    }

    protected void beginLoading() {
    }

    public void load(String root) {
        this.root = root;
        this.beginLoading();
        for (Folder folder : this.data.folders) {
            for (File file : folder.files) {
                FileReference ref = new FileReference(folder.id, file.id);
                this.resources.put(ref, this.loadResource(ref));
            }
        }
        this.disposed = false;
        this.finishLoading();
    }

    public void load(java.io.File file) {
        this.load(file.getParent());
    }

    public R get(FileReference ref) {
        return this.resources.get(ref);
    }

    public void dispose() {
        this.resources.clear();
        this.data = null;
        this.root = "";
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

