/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Calculator;

public class Interpolator {
    public static float linear(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static float linearAngle(float a, float b, float t) {
        return a + Calculator.angleDifference(b, a) * t;
    }

    public static float quadratic(float a, float b, float c, float t) {
        return Interpolator.linear(Interpolator.linear(a, b, t), Interpolator.linear(b, c, t), t);
    }

    public static float quadraticAngle(float a, float b, float c, float t) {
        return Interpolator.linearAngle(Interpolator.linearAngle(a, b, t), Interpolator.linearAngle(b, c, t), t);
    }

    public static float cubic(float a, float b, float c, float d, float t) {
        return Interpolator.linear(Interpolator.quadratic(a, b, c, t), Interpolator.quadratic(b, c, d, t), t);
    }

    public static float cubicAngle(float a, float b, float c, float d, float t) {
        return Interpolator.linearAngle(Interpolator.quadraticAngle(a, b, c, t), Interpolator.quadraticAngle(b, c, d, t), t);
    }

    public static float quartic(float a, float b, float c, float d, float e, float t) {
        return Interpolator.linear(Interpolator.cubic(a, b, c, d, t), Interpolator.cubic(b, c, d, e, t), t);
    }

    public static float quarticAngle(float a, float b, float c, float d, float e, float t) {
        return Interpolator.linearAngle(Interpolator.cubicAngle(a, b, c, d, t), Interpolator.cubicAngle(b, c, d, e, t), t);
    }

    public static float quintic(float a, float b, float c, float d, float e, float f, float t) {
        return Interpolator.linear(Interpolator.quartic(a, b, c, d, e, t), Interpolator.quartic(b, c, d, e, f, t), t);
    }

    public static float quinticAngle(float a, float b, float c, float d, float e, float f, float t) {
        return Interpolator.linearAngle(Interpolator.quarticAngle(a, b, c, d, e, t), Interpolator.quarticAngle(b, c, d, e, f, t), t);
    }

    public static float bezier(float t, float x1, float x2, float x3, float x4) {
        return Interpolator.bezier0(t) * x1 + Interpolator.bezier1(t) * x2 + Interpolator.bezier2(t) * x3 + Interpolator.bezier3(t) * x4;
    }

    private static float bezier0(float t) {
        float temp = t * t;
        return -temp * t + 3.0f * temp - 3.0f * t + 1.0f;
    }

    private static float bezier1(float t) {
        float temp = t * t;
        return 3.0f * t * temp - 6.0f * temp + 3.0f * t;
    }

    private static float bezier2(float t) {
        float temp = t * t;
        return -3.0f * temp * t + 3.0f * temp;
    }

    private static float bezier3(float t) {
        return t * t * t;
    }
}

