/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.IKObject;
import com.brashmonkey.spriter.Mainline;
import com.brashmonkey.spriter.Player;
import com.brashmonkey.spriter.SpriterException;
import com.brashmonkey.spriter.Timeline;
import java.util.HashMap;
import java.util.Map;

public abstract class IKResolver {
    protected HashMap<IKObject, Mainline.Key.BoneRef> ikMap = new HashMap();
    protected float tolerance = 5.0f;
    protected Player player;

    protected abstract void resolve(float var1, float var2, int var3, Mainline.Key.BoneRef var4);

    public IKResolver(Player player) {
        this.setPlayer(player);
    }

    public void setPlayer(Player player) {
        if (player == null) {
            throw new SpriterException("player cannot be null!");
        }
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void resolve() {
        for (Map.Entry<IKObject, Mainline.Key.BoneRef> entry : this.ikMap.entrySet()) {
            for (int j = 0; j < entry.getKey().iterations; ++j) {
                this.resolve(entry.getKey().x, entry.getKey().y, entry.getKey().chainLength, entry.getValue());
            }
        }
    }

    public void mapIKObject(IKObject ikObject, Mainline.Key.BoneRef boneRef) {
        this.ikMap.put(ikObject, boneRef);
    }

    public void mapIKObject(IKObject ikObject, Timeline.Key.Bone bone) {
        this.ikMap.put(ikObject, this.player.getBoneRef(bone));
    }

    public void unmapIKObject(IKObject ikObject) {
        this.ikMap.remove(ikObject);
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(float tolerance) {
        this.tolerance = tolerance;
    }
}

