/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Curve;
import com.brashmonkey.spriter.Mainline;
import com.brashmonkey.spriter.Point;
import com.brashmonkey.spriter.SpriterException;
import com.brashmonkey.spriter.Timeline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Animation {
    public final Mainline mainline;
    private final List<Timeline> timelines;
    private final HashMap<String, Timeline> nameToTimeline;
    public final int id;
    public final int length;
    public final String name;
    public final boolean looping;
    Mainline.Key currentKey;
    Timeline.Key[] tweenedKeys;
    Timeline.Key[] unmappedTweenedKeys;
    private boolean prepared;

    public Animation(Mainline mainline, int id, String name, int length, boolean looping) {
        this(mainline, id, name, length, looping, new ArrayList<Timeline>());
    }

    public Animation(int id, String name, int length, boolean looping, List<Timeline> timelines) {
        this(new Mainline(), id, name, length, looping, timelines);
    }

    public Animation(Mainline mainline, int id, String name, int length, boolean looping, List<Timeline> timelines) {
        this.mainline = mainline;
        this.id = id;
        this.name = name;
        this.length = length;
        this.looping = looping;
        this.timelines = timelines;
        this.prepared = false;
        this.nameToTimeline = new HashMap();
    }

    public Animation(Mainline mainline, int id, String name, int length) {
        this(mainline, id, name, length, true);
    }

    public Animation(int id, String name, int length, boolean looping) {
        this(new Mainline(), id, name, length, looping);
    }

    public Timeline getTimeline(int index) {
        return this.timelines.get(index);
    }

    public Timeline getTimeline(String name) {
        return this.nameToTimeline.get(name);
    }

    void addTimeline(Timeline timeline) {
        this.timelines.add(timeline);
        this.nameToTimeline.put(timeline.name, timeline);
    }

    public int timelines() {
        return this.timelines.size();
    }

    public String toString() {
        String toReturn = this.getClass().getSimpleName() + "|[id: " + this.id + ", " + this.name + ", duration: " + this.length + ", is looping: " + this.looping;
        toReturn = toReturn + "Mainline:\n";
        toReturn = toReturn + this.mainline;
        toReturn = toReturn + "Timelines\n";
        for (Timeline timeline : this.timelines) {
            toReturn = toReturn + timeline;
        }
        toReturn = toReturn + "]";
        return toReturn;
    }

    public void update(int time, Timeline.Key.Bone root) {
        if (!this.prepared) {
            throw new SpriterException("This animation is not ready yet to animate itself. Please call prepare()!");
        }
        if (root == null) {
            throw new SpriterException("The root can not be null! Set a root bone to apply this animation relative to the root bone.");
        }
        this.currentKey = this.mainline.getKeyBeforeTime(time);
        for (Timeline.Key timelineKey : this.unmappedTweenedKeys) {
            timelineKey.active = false;
        }
        for (Mainline.Key.BoneRef ref : this.currentKey.boneRefs) {
            this.update(ref, root, time);
        }
        for (Mainline.Key.ObjectRef ref : this.currentKey.objectRefs) {
            this.update(ref, root, time);
        }
    }

    protected void update(Mainline.Key.BoneRef ref, Timeline.Key.Bone root, int time) {
        float t;
        boolean isObject = ref instanceof Mainline.Key.ObjectRef;
        Timeline timeline = this.getTimeline(ref.timeline);
        Timeline.Key key = timeline.getKey(ref.key);
        Timeline.Key nextKey = timeline.getKey((ref.key + 1) % timeline.keys.size());
        int nextTime = nextKey.time;
        int currentTime = key.time;
        if (nextTime < currentTime) {
            if (!this.looping) {
                nextKey = key;
            } else {
                nextTime = this.length;
            }
        }
        if (Float.isNaN(t = (float)(time - currentTime) / (float)(nextTime - currentTime)) || Float.isInfinite(t)) {
            t = 1.0f;
        }
        if (this.currentKey.time > currentTime) {
            float tMid = (float)(this.currentKey.time - currentTime) / (float)(nextTime - currentTime);
            if (Float.isNaN(tMid) || Float.isInfinite(tMid)) {
                tMid = 0.0f;
            }
            if (Float.isNaN(t = (float)(time - this.currentKey.time) / (float)(nextTime - this.currentKey.time)) || Float.isInfinite(t)) {
                t = 1.0f;
            }
            t = this.currentKey.curve.tween(tMid, 1.0f, t);
        } else {
            t = this.currentKey.curve.tween(0.0f, 1.0f, t);
        }
        Timeline.Key.Object bone1 = key.object();
        Timeline.Key.Object bone2 = nextKey.object();
        Timeline.Key.Object tweenTarget = this.tweenedKeys[ref.timeline].object();
        if (isObject) {
            this.tweenObject(bone1, bone2, tweenTarget, t, key.curve, key.spin);
        } else {
            this.tweenBone(bone1, bone2, tweenTarget, t, key.curve, key.spin);
        }
        this.unmappedTweenedKeys[ref.timeline].active = true;
        this.unmapTimelineObject(ref.timeline, isObject, ref.parent != null ? this.unmappedTweenedKeys[ref.parent.timeline].object() : root);
    }

    void unmapTimelineObject(int timeline, boolean isObject, Timeline.Key.Bone root) {
        Timeline.Key.Object tweenTarget = this.tweenedKeys[timeline].object();
        Timeline.Key.Object mapTarget = this.unmappedTweenedKeys[timeline].object();
        if (isObject) {
            mapTarget.set(tweenTarget);
        } else {
            mapTarget.set((Timeline.Key.Bone)tweenTarget);
        }
        mapTarget.unmap(root);
    }

    protected void tweenBone(Timeline.Key.Bone bone1, Timeline.Key.Bone bone2, Timeline.Key.Bone target, float t, Curve curve, int spin) {
        target.angle = curve.tweenAngle(bone1.angle, bone2.angle, t, spin);
        curve.tweenPoint(bone1.position, bone2.position, t, target.position);
        curve.tweenPoint(bone1.scale, bone2.scale, t, target.scale);
        curve.tweenPoint(bone1.pivot, bone2.pivot, t, target.pivot);
    }

    protected void tweenObject(Timeline.Key.Object object1, Timeline.Key.Object object2, Timeline.Key.Object target, float t, Curve curve, int spin) {
        this.tweenBone(object1, object2, target, t, curve, spin);
        target.alpha = curve.tweenAngle(object1.alpha, object2.alpha, t);
        target.ref.set(object1.ref);
    }

    Timeline getSimilarTimeline(Timeline t) {
        Timeline found = this.getTimeline(t.name);
        if (found == null && t.id < this.timelines()) {
            found = this.getTimeline(t.id);
        }
        return found;
    }

    Timeline getSimilarTimeline(Mainline.Key.BoneRef ref, Collection<Timeline> coveredTimelines) {
        if (ref.parent == null) {
            return null;
        }
        for (Mainline.Key.BoneRef boneRef : this.currentKey.objectRefs) {
            Timeline t = this.getTimeline(boneRef.timeline);
            if (boneRef.parent == null || boneRef.parent.id != ref.parent.id || coveredTimelines.contains(t)) continue;
            return t;
        }
        return null;
    }

    Timeline getSimilarTimeline(Mainline.Key.ObjectRef ref, Collection<Timeline> coveredTimelines) {
        if (ref.parent == null) {
            return null;
        }
        for (Mainline.Key.ObjectRef objRef : this.currentKey.objectRefs) {
            Timeline t = this.getTimeline(objRef.timeline);
            if (objRef.parent == null || objRef.parent.id != ref.parent.id || coveredTimelines.contains(t)) continue;
            return t;
        }
        return null;
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        this.tweenedKeys = new Timeline.Key[this.timelines.size()];
        this.unmappedTweenedKeys = new Timeline.Key[this.timelines.size()];
        for (int i = 0; i < this.tweenedKeys.length; ++i) {
            this.tweenedKeys[i] = new Timeline.Key(i);
            this.unmappedTweenedKeys[i] = new Timeline.Key(i);
            this.tweenedKeys[i].setObject(new Timeline.Key.Object(new Point(0.0f, 0.0f)));
            this.unmappedTweenedKeys[i].setObject(new Timeline.Key.Object(new Point(0.0f, 0.0f)));
        }
        if (this.mainline.keys.size() > 0) {
            this.currentKey = this.mainline.getKey(0);
        }
        this.prepared = true;
    }
}

