/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.screens.SingleCardViewPopup;

import basemod.abstracts.CustomCard;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import com.megacrit.cardcrawl.screens.SingleCardViewPopup;
import java.util.HashMap;
import java.util.Map;
import javassist.CtBehavior;

public class TitleFontSize {
    public static FileHandle fontFile;
    private static Map<Class<? extends CustomCard>, BitmapFont> titleFontMap;
    private static BitmapFont savedFont;

    private static BitmapFont getTitleFont(CustomCard card) {
        if (card.getTitleFontSize() < 0.0f) {
            return null;
        }
        BitmapFont font = titleFontMap.get(((Object)((Object)card)).getClass());
        if (font == null) {
            font = TitleFontSize.generateTitleFont(card.getTitleFontSize() * 2.0f);
            titleFontMap.put(((Object)((Object)card)).getClass(), font);
        }
        return font;
    }

    private static BitmapFont generateTitleFont(float size) {
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        param.minFilter = Texture.TextureFilter.Linear;
        param.magFilter = Texture.TextureFilter.Linear;
        param.hinting = FreeTypeFontGenerator.Hinting.Slight;
        param.spaceX = 0;
        param.kerning = true;
        param.borderColor = new Color(0.35f, 0.35f, 0.35f, 1.0f);
        param.borderWidth = 4.0f * Settings.scale;
        param.gamma = 0.9f;
        param.borderGamma = 0.9f;
        param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        param.shadowOffsetX = Math.round(6.0f * Settings.scale);
        param.shadowOffsetY = Math.round(6.0f * Settings.scale);
        param.borderStraight = false;
        param.characters = "";
        param.incremental = true;
        param.size = Math.round(size * Settings.scale);
        FreeTypeFontGenerator g = new FreeTypeFontGenerator(fontFile);
        g.scaleForPixelHeight(param.size);
        BitmapFont font = g.generateFont(param);
        font.setUseIntegerPositions(false);
        font.getData().markupEnabled = true;
        if (LocalizedStrings.break_chars != null) {
            font.getData().breakChars = LocalizedStrings.break_chars.toCharArray();
        }
        return font;
    }

    static {
        titleFontMap = new HashMap<Class<? extends CustomCard>, BitmapFont>();
    }

    @SpirePatch(clz=FontHelper.class, method="initialize")
    public static class GrabFontFile {
        @SpireInsertPatch(locator=Locator.class, localvars={"fontFile"})
        public static void Insert(FileHandle localFontFile) {
            fontFile = localFontFile;
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
                Matcher.FieldAccessMatcher finalMatcher = new Matcher.FieldAccessMatcher(FontHelper.class, "cardTitleFont_small");
                return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatch(clz=SingleCardViewPopup.class, method="renderTitle")
    public static class UseCustomFontSize {
        @SpireInsertPatch(rloc=0, localvars={"card"})
        public static void Insert(SingleCardViewPopup __instance, SpriteBatch sb, AbstractCard card) {
            BitmapFont titleFont;
            savedFont = FontHelper.SCP_cardTitleFont_small;
            if (!card.isLocked && card.isSeen && card instanceof CustomCard && (titleFont = TitleFontSize.getTitleFont((CustomCard)card)) != null) {
                FontHelper.SCP_cardTitleFont_small = titleFont;
            }
        }

        public static void Postfix(SingleCardViewPopup __instance, SpriteBatch sb) {
            FontHelper.SCP_cardTitleFont_small = savedFont;
        }
    }
}

