/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.helpers.FontHelper;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.helpers.FontHelper;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;

public class AllowSmartTextsToRemoveSpaces {
    public static final String REMOVE_SPACE_SPECIAL_KEYWORD = "[REMOVE_SPACE]";

    private static ExprEditor changeSecondLayoutWidthExprEditor(final int[] counter, final String className) {
        return new ExprEditor(){

            public void edit(FieldAccess f) throws CannotCompileException {
                if (f.getFieldName().equals("width")) {
                    counter[0] = counter[0] + 1;
                    if (counter[0] == 2) {
                        f.replace("if(" + className + ".forceNotBreakingLine) $_ = 0.0F; else $_ = $proceed($$);");
                    }
                }
            }
        };
    }

    @SpirePatch(clz=FontHelper.class, method="getSmartHeight", paramtypez={BitmapFont.class, String.class, float.class, float.class})
    public static class GetSmartHeightPatch {
        public static boolean forceNotBreakingLine = false;

        @SpireInsertPatch(locator=RemoveSpecialWordLocator.class, localvars={"word"})
        public static void Insert(BitmapFont font, String msg, float lineWidth, float lineSpacing, @ByRef String[] word) {
            forceNotBreakingLine = false;
            if (word[0].startsWith(AllowSmartTextsToRemoveSpaces.REMOVE_SPACE_SPECIAL_KEYWORD)) {
                word[0] = word[0].replace(AllowSmartTextsToRemoveSpaces.REMOVE_SPACE_SPECIAL_KEYWORD, "");
                if (word[0].length() == 1) {
                    forceNotBreakingLine = true;
                }
            }
        }

        public static ExprEditor Instrument() throws CannotCompileException {
            int[] counter = new int[]{0};
            return AllowSmartTextsToRemoveSpaces.changeSecondLayoutWidthExprEditor(counter, GetSmartHeightPatch.class.getName());
        }

        private static class RemoveSpecialWordLocator
        extends SpireInsertLocator {
            private RemoveSpecialWordLocator() {
            }

            public int[] Locate(CtBehavior method) throws Exception {
                Matcher.MethodCallMatcher matcher = new Matcher.MethodCallMatcher(String.class, "equals");
                return LineFinder.findInOrder((CtBehavior)method, (Matcher)matcher);
            }
        }
    }

    @SpirePatch(clz=FontHelper.class, method="renderSmartText", paramtypez={SpriteBatch.class, BitmapFont.class, String.class, float.class, float.class, float.class, float.class, Color.class})
    public static class RenderSmartTextPatch {
        public static boolean removeSpace = false;
        public static boolean forceNotBreakingLine = false;

        @SpireInsertPatch(locator=RemoveSpecialWordLocator.class, localvars={"word"})
        public static void InsertRemoveSpecialWord(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float lineWidth, float lineSpacing, Color baseColor, @ByRef String[] word) {
            removeSpace = false;
            forceNotBreakingLine = false;
            if (word[0].startsWith(AllowSmartTextsToRemoveSpaces.REMOVE_SPACE_SPECIAL_KEYWORD)) {
                word[0] = word[0].replace(AllowSmartTextsToRemoveSpaces.REMOVE_SPACE_SPECIAL_KEYWORD, "");
                removeSpace = true;
                if (word[0].length() == 1) {
                    forceNotBreakingLine = true;
                }
            }
        }

        @SpireInsertPatch(locator=RemoveSpaceLocator.class, localvars={"curWidth", "spaceWidth"})
        public static void InsertRemoveSpace(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float lineWidth, float lineSpacing, Color baseColor, @ByRef float[] curWidth, float spaceWidth) {
            if (removeSpace) {
                curWidth[0] = curWidth[0] - spaceWidth;
            }
        }

        public static ExprEditor Instrument() throws CannotCompileException {
            int[] counter = new int[]{0};
            return AllowSmartTextsToRemoveSpaces.changeSecondLayoutWidthExprEditor(counter, RenderSmartTextPatch.class.getName());
        }

        private static class RemoveSpaceLocator
        extends SpireInsertLocator {
            private RemoveSpaceLocator() {
            }

            public int[] Locate(CtBehavior method) throws Exception {
                Matcher.MethodCallMatcher matcher = new Matcher.MethodCallMatcher(BitmapFont.class, "draw");
                ArrayList<Matcher.MethodCallMatcher> prereqs = new ArrayList<Matcher.MethodCallMatcher>();
                prereqs.add(matcher);
                return LineFinder.findInOrder((CtBehavior)method, prereqs, (Matcher)matcher);
            }
        }

        private static class RemoveSpecialWordLocator
        extends SpireInsertLocator {
            private RemoveSpecialWordLocator() {
            }

            public int[] Locate(CtBehavior method) throws Exception {
                Matcher.MethodCallMatcher matcher = new Matcher.MethodCallMatcher(String.class, "equals");
                return LineFinder.findInOrder((CtBehavior)method, (Matcher)matcher);
            }
        }
    }
}

