/*
 * Decompiled with CFR 0.152.
 */
package basemod.helpers;

import basemod.helpers.ModalChoice;
import basemod.helpers.ModalChoiceCard;
import com.megacrit.cardcrawl.cards.AbstractCard;
import java.util.ArrayList;

public class ModalChoiceBuilder {
    private String title = "Choose an Option";
    private ArrayList<AbstractCard> options = new ArrayList();
    private ModalChoice.Callback callback = null;
    private AbstractCard.CardColor color = AbstractCard.CardColor.COLORLESS;
    private AbstractCard.CardType type = AbstractCard.CardType.SKILL;

    public ModalChoice create() {
        return new ModalChoice(this.title, this.options);
    }

    public ModalChoiceBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ModalChoiceBuilder addOption(String description, AbstractCard.CardTarget target) {
        return this.addOption(null, description, target);
    }

    public ModalChoiceBuilder addOption(String title, String description, AbstractCard.CardTarget target) {
        if (title == null) {
            title = "Option " + (this.options.size() + 1);
        }
        return this.addOption(new ModalChoiceCard(title, description, this.type, this.color, target, this.options.size(), this.callback));
    }

    public ModalChoiceBuilder addOption(AbstractCard card) {
        this.options.add(card);
        return this;
    }

    public ModalChoiceBuilder setColor(AbstractCard.CardColor color) {
        this.color = color;
        return this;
    }

    public ModalChoiceBuilder setType(AbstractCard.CardType type) {
        this.type = type;
        return this;
    }

    public ModalChoiceBuilder setCallback(ModalChoice.Callback callback) {
        this.callback = callback;
        return this;
    }
}

