/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.hand;

import basemod.BaseMod;
import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import basemod.devcommands.hand.HandAdd;
import basemod.devcommands.hand.HandDiscard;
import basemod.devcommands.hand.HandRemove;
import basemod.devcommands.hand.HandSet;
import basemod.helpers.ConvertHelper;
import java.util.Arrays;

public class Hand
extends ConsoleCommand {
    public Hand() {
        this.followup.put("add", HandAdd.class);
        this.followup.put("remove", HandRemove.class);
        this.followup.put("discard", HandDiscard.class);
        this.followup.put("set", HandSet.class);
        this.requiresPlayer = true;
        this.simpleCheck = true;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        Hand.cmdHandHelp();
    }

    @Override
    public void errorMsg() {
        Hand.cmdHandHelp();
    }

    public static int countIndex(String[] tokens) {
        int countIndex = tokens.length - 1;
        while (ConvertHelper.tryParseInt(tokens[countIndex], 0) != 0) {
            --countIndex;
        }
        return countIndex;
    }

    public static String cardName(String[] tokens) {
        return Hand.cardName(tokens, Hand.countIndex(tokens));
    }

    public static String cardName(String[] tokens, int countIndex) {
        CharSequence[] cardNameArray = Arrays.copyOfRange(tokens, 2, countIndex + 1);
        String cardName = String.join((CharSequence)" ", cardNameArray);
        if (BaseMod.underScoreCardIDs.containsKey(cardName)) {
            cardName = BaseMod.underScoreCardIDs.get(cardName);
        }
        return cardName;
    }

    public static void cmdHandHelp() {
        DevConsole.couldNotParse();
        DevConsole.log("options are:");
        DevConsole.log("* add [id] {count} {upgrade amt}");
        DevConsole.log("* remove [id]");
        DevConsole.log("* remove all");
        DevConsole.log("* discard [id]");
        DevConsole.log("* discard all");
        DevConsole.log("* set damage [id] [amount]");
        DevConsole.log("* set block [id] [amount]");
        DevConsole.log("* set magic [id] [amount]");
        DevConsole.log("* set cost [id] [amount]");
    }
}

