/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.event;

import basemod.BaseMod;
import basemod.CustomEventRoom;
import basemod.DevConsole;
import basemod.ReflectionHacks;
import basemod.devcommands.ConsoleCommand;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.helpers.EventHelper;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import com.megacrit.cardcrawl.map.MapEdge;
import com.megacrit.cardcrawl.map.MapRoomNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class Event
extends ConsoleCommand {
    public Event() {
        this.requiresPlayer = true;
        this.minExtraTokens = 1;
        this.maxExtraTokens = 1;
        this.simpleCheck = true;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        if (AbstractDungeon.currMapNode == null) {
            DevConsole.log("cannot execute event when there is no map");
            return;
        }
        CharSequence[] eventArray = Arrays.copyOfRange(tokens, 1, tokens.length);
        String eventName = String.join((CharSequence)" ", eventArray);
        if (BaseMod.underScoreEventIDs.containsKey(eventName)) {
            eventName = BaseMod.underScoreEventIDs.get(eventName);
        }
        if (EventHelper.getEvent((String)eventName) == null) {
            DevConsole.couldNotParse();
            DevConsole.log(eventName + " is not an event ID");
            return;
        }
        AbstractDungeon.eventList.add(0, eventName);
        MapRoomNode cur = AbstractDungeon.currMapNode;
        MapRoomNode node = new MapRoomNode(cur.x, cur.y);
        node.room = new CustomEventRoom();
        ArrayList curEdges = cur.getEdges();
        for (MapEdge edge : curEdges) {
            node.addEdge(edge);
        }
        AbstractDungeon.player.releaseCard();
        AbstractDungeon.overlayMenu.hideCombatPanels();
        AbstractDungeon.previousScreen = null;
        AbstractDungeon.dynamicBanner.hide();
        AbstractDungeon.dungeonMapScreen.closeInstantly();
        AbstractDungeon.closeCurrentScreen();
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.fadeIn();
        AbstractDungeon.effectList.clear();
        AbstractDungeon.topLevelEffects.clear();
        AbstractDungeon.topLevelEffectsQueue.clear();
        AbstractDungeon.effectsQueue.clear();
        AbstractDungeon.dungeonMapScreen.dismissable = true;
        AbstractDungeon.nextRoom = node;
        AbstractDungeon.setCurrMapNode((MapRoomNode)node);
        AbstractDungeon.getCurrRoom().onPlayerEntry();
        AbstractDungeon.scene.nextRoom(node.room);
        AbstractDungeon.rs = node.room.event instanceof AbstractImageEvent ? AbstractDungeon.RenderScene.EVENT : AbstractDungeon.RenderScene.NORMAL;
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        ArrayList<String> result = new ArrayList<String>();
        Map events = (Map)ReflectionHacks.getPrivateStatic(LocalizedStrings.class, "events");
        if (events != null) {
            for (String key : events.keySet()) {
                result.add(key.replace(' ', '_'));
            }
        }
        return result;
    }
}

