/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.deck;

import basemod.BaseMod;
import basemod.devcommands.ConsoleCommand;
import basemod.devcommands.deck.Deck;
import basemod.helpers.ConvertHelper;
import java.util.Arrays;

public abstract class DeckManipulator
extends ConsoleCommand {
    public DeckManipulator() {
        this.requiresPlayer = true;
        this.minExtraTokens = 1;
    }

    protected String getCardID(String[] tokens) {
        return this.getCardID(tokens, this.countIndex(tokens));
    }

    protected String getCardID(String[] tokens, int countIndex) {
        CharSequence[] cardNameArray = Arrays.copyOfRange(tokens, 2, countIndex + 1);
        String cardName = String.join((CharSequence)" ", cardNameArray);
        if (BaseMod.underScoreCardIDs.containsKey(cardName)) {
            cardName = BaseMod.underScoreCardIDs.get(cardName);
        }
        return cardName;
    }

    protected int countIndex(String[] tokens) {
        int countIndex = tokens.length - 1;
        while (ConvertHelper.tryParseInt(tokens[countIndex], 0) != 0) {
            --countIndex;
        }
        return countIndex;
    }

    @Override
    public void errorMsg() {
        Deck.cmdDeckHelp();
    }
}

