/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands;

import basemod.BaseMod;
import basemod.DevConsole;
import basemod.devcommands.Help;
import basemod.devcommands.Info;
import basemod.devcommands.InvalidCommandException;
import basemod.devcommands.act.ActCommand;
import basemod.devcommands.blight.Blight;
import basemod.devcommands.clear.Clear;
import basemod.devcommands.debug.Debug;
import basemod.devcommands.deck.Deck;
import basemod.devcommands.draw.Draw;
import basemod.devcommands.energy.Energy;
import basemod.devcommands.event.Event;
import basemod.devcommands.fight.Fight;
import basemod.devcommands.gold.Gold;
import basemod.devcommands.hand.Hand;
import basemod.devcommands.history.History;
import basemod.devcommands.hp.Hp;
import basemod.devcommands.key.KeyCommand;
import basemod.devcommands.kill.Kill;
import basemod.devcommands.maxhp.MaxHp;
import basemod.devcommands.potions.Potions;
import basemod.devcommands.power.Power;
import basemod.devcommands.relic.Relic;
import basemod.devcommands.unlock.Unlock;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ConsoleCommand {
    protected Map<String, Class<? extends ConsoleCommand>> followup = new HashMap<String, Class<? extends ConsoleCommand>>();
    protected boolean simpleCheck = false;
    protected boolean requiresPlayer = false;
    protected int minExtraTokens = 0;
    protected int maxExtraTokens = 1;
    private static Map<String, Class<? extends ConsoleCommand>> root = new HashMap<String, Class<? extends ConsoleCommand>>();
    public static boolean complete;
    public static boolean isNumber;
    public static boolean duringRun;
    public static String errormsg;

    protected abstract void execute(String[] var1, int var2);

    protected ArrayList<String> extraOptions(String[] tokens, int depth) {
        if (this.followup.isEmpty()) {
            if (tokens.length > depth && tokens[depth].length() > 0) {
                ConsoleCommand.tooManyTokensError();
            } else {
                complete = true;
            }
        }
        return new ArrayList<String>();
    }

    protected void errorMsg(String[] tokens) {
        this.errorMsg();
    }

    protected void errorMsg() {
    }

    private ConsoleCommand last(String[] tokens, int[] depth, boolean forExecution) throws IllegalAccessException, InstantiationException, InvalidCommandException {
        if (depth[0] < tokens.length - (forExecution ? 0 : 1) && this.followup.containsKey(tokens[depth[0]].toLowerCase())) {
            ConsoleCommand cc = this.followup.get(tokens[depth[0]].toLowerCase()).newInstance();
            depth[0] = depth[0] + 1;
            return cc.last(tokens, depth, forExecution);
        }
        if (this.requiresPlayer && AbstractDungeon.player == null) {
            if (forExecution) {
                DevConsole.log("This action can only be executed during a run.");
            } else {
                duringRun = true;
            }
        } else if (forExecution && tokens.length < depth[0] + this.minExtraTokens) {
            this.errorMsg();
        } else if (!forExecution && this.maxExtraTokens > 0 && tokens.length > this.maxExtraTokens + depth[0] && tokens[depth[0] + this.maxExtraTokens].length() > 0) {
            ConsoleCommand.tooManyTokensError();
        } else {
            return this;
        }
        throw new InvalidCommandException();
    }

    private ArrayList<String> autocomplete(String[] tokens, int depth) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.followup.keySet()) {
            if (!key.toLowerCase().startsWith(tokens[depth].toLowerCase())) continue;
            result.add(key);
        }
        ArrayList<String> extras = this.extraOptions(tokens, depth);
        if (extras != null) {
            for (String key : extras) {
                if (!key.toLowerCase().startsWith(tokens[tokens.length - 1].toLowerCase())) continue;
                result.add(key);
            }
        }
        Collections.sort(result);
        return result;
    }

    private static ConsoleCommand getLastCommand(String[] tokens, int[] depth, boolean forExecution) {
        try {
            ConsoleCommand cc = new ConsoleCommand(){

                @Override
                protected void execute(String[] tokens, int depth) {
                }
            };
            cc.followup = root;
            cc = super.last(tokens, depth, forExecution);
            return cc;
        }
        catch (InvalidCommandException cc) {
        }
        catch (Exception ex) {
            if (forExecution) {
                DevConsole.log("An error occurred.");
            }
            BaseMod.logger.error((Object)ex.getStackTrace());
        }
        return null;
    }

    public static void initialize() {
        ConsoleCommand.addCommand("deck", Deck.class);
        ConsoleCommand.addCommand("potion", Potions.class);
        ConsoleCommand.addCommand("blight", Blight.class);
        ConsoleCommand.addCommand("clear", Clear.class);
        ConsoleCommand.addCommand("debug", Debug.class);
        ConsoleCommand.addCommand("draw", Draw.class);
        ConsoleCommand.addCommand("energy", Energy.class);
        ConsoleCommand.addCommand("event", Event.class);
        ConsoleCommand.addCommand("fight", Fight.class);
        ConsoleCommand.addCommand("gold", Gold.class);
        ConsoleCommand.addCommand("hand", Hand.class);
        ConsoleCommand.addCommand("help", Help.class);
        ConsoleCommand.addCommand("hp", Hp.class);
        ConsoleCommand.addCommand("info", Info.class);
        ConsoleCommand.addCommand("kill", Kill.class);
        ConsoleCommand.addCommand("maxhp", MaxHp.class);
        ConsoleCommand.addCommand("power", Power.class);
        ConsoleCommand.addCommand("relic", Relic.class);
        ConsoleCommand.addCommand("unlock", Unlock.class);
        ConsoleCommand.addCommand("history", History.class);
        ConsoleCommand.addCommand("act", ActCommand.class);
        ConsoleCommand.addCommand("key", KeyCommand.class);
        ActCommand.initialize();
    }

    public static Iterator<String> getKeys() {
        return root.keySet().iterator();
    }

    public static void addCommand(String key, Class<? extends ConsoleCommand> val) {
        if (root.containsKey(key)) {
            BaseMod.logger.error("Command \"" + key + "\" already exists.");
        } else if (!key.matches("[a-zA-Z:]+")) {
            BaseMod.logger.error("Commands cannot contain whitespaces.");
        } else {
            root.put(key, val);
        }
    }

    public static void execute(String[] tokens) {
        int[] depth = new int[]{0};
        ConsoleCommand cc = ConsoleCommand.getLastCommand(tokens, depth, true);
        if (cc != null) {
            cc.execute(tokens, depth[0]);
        }
    }

    public static ArrayList<String> suggestions(String[] tokens) {
        complete = false;
        isNumber = false;
        duringRun = false;
        errormsg = null;
        int[] depth = new int[]{0};
        ConsoleCommand cc = ConsoleCommand.getLastCommand(tokens, depth, false);
        if (cc != null) {
            ArrayList<String> result = cc.autocomplete(tokens, depth[0]);
            if (cc.simpleCheck && result.contains(tokens[depth[0]])) {
                result.clear();
                complete = true;
            }
            if (!complete && !duringRun && errormsg == null) {
                return result;
            }
        }
        return new ArrayList<String>();
    }

    public static ArrayList<String> smallNumbers() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= 9; ++i) {
            result.add(String.valueOf(i));
        }
        isNumber = true;
        return result;
    }

    public static ArrayList<String> mediumNumbers() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 10; i <= 90; i += 10) {
            result.add(String.valueOf(i));
            result.add(String.valueOf(i * 10));
        }
        isNumber = true;
        return result;
    }

    public static ArrayList<String> bigNumbers() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 100; i <= 900; i += 100) {
            result.add(String.valueOf(i));
            result.add(String.valueOf(i * 10));
        }
        isNumber = true;
        return result;
    }

    public static ArrayList<String> getCardOptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : CardLibrary.cards.keySet()) {
            result.add(key.replace(' ', '_'));
        }
        return result;
    }

    public static ArrayList<String> getCardOptionsFromCardGroup(CardGroup cg) {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractCard card : cg.group) {
            String cardid = card.cardID.replace(' ', '_');
            if (result.contains(cardid)) continue;
            result.add(cardid);
        }
        return result;
    }

    public static ArrayList<String> getRelicOptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : BaseMod.listAllRelicIDs()) {
            result.add(id.replace(' ', '_'));
        }
        return result;
    }

    public static void tooManyTokensError() {
        errormsg = "Too many tokens";
    }
}

