/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts.cardbuilder.actionbuilder;

import basemod.abstracts.cardbuilder.actionbuilder.ApplyPowerActionBuilder;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.powers.DexterityPower;
import com.megacrit.cardcrawl.powers.FrailPower;
import com.megacrit.cardcrawl.powers.StrengthPower;
import com.megacrit.cardcrawl.powers.VulnerablePower;
import com.megacrit.cardcrawl.powers.WeakPower;
import java.util.function.Supplier;

public class EffectActionBuilder
extends ApplyPowerActionBuilder {
    private static ApplyPowerActionBuilder.PowerFunction buildPower(Effect type) {
        return (card, player, monster, amount) -> {
            switch (type) {
                case STRENGTH: {
                    return new StrengthPower((AbstractCreature)player, amount.intValue());
                }
                case DEXTERITY: {
                    return new DexterityPower((AbstractCreature)player, amount.intValue());
                }
                case FRAIL: {
                    return new FrailPower((AbstractCreature)player, amount.intValue(), false);
                }
                case VULNERABLE: {
                    return new VulnerablePower((AbstractCreature)player, amount.intValue(), false);
                }
                case WEAK: {
                    return new WeakPower((AbstractCreature)player, amount.intValue(), false);
                }
            }
            return null;
        };
    }

    private static Supplier<String> effectName(Effect type) {
        return () -> {
            switch (type) {
                case STRENGTH: {
                    return "Strength";
                }
                case DEXTERITY: {
                    return "Dexterity";
                }
                case FRAIL: {
                    return "Frail";
                }
                case VULNERABLE: {
                    return "Vulnerable";
                }
                case WEAK: {
                    return "Weak";
                }
            }
            return null;
        };
    }

    public EffectActionBuilder(Effect type) {
        super(EffectActionBuilder.buildPower(type), EffectActionBuilder.effectName(type));
    }

    public EffectActionBuilder(Effect type, int amount, int upgradedAmount) {
        super(amount, upgradedAmount, EffectActionBuilder.buildPower(type), EffectActionBuilder.effectName(type));
    }

    public static enum Effect {
        STRENGTH,
        DEXTERITY,
        VULNERABLE,
        WEAK,
        FRAIL;

    }
}

