/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts.cardbuilder.actionbuilder;

import basemod.abstracts.cardbuilder.CardBasic;
import basemod.abstracts.cardbuilder.actionbuilder.AmountActionBuilder;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import java.util.function.Supplier;

public class ApplyPowerActionBuilder
extends AmountActionBuilder {
    private PowerFunction buildPower;
    private Supplier<String> effectName;
    private PowerTarget target;
    private boolean doTarget = false;

    public ApplyPowerActionBuilder(PowerFunction buildPower, Supplier<String> effectName) {
        this.buildPower = buildPower;
        this.effectName = effectName;
    }

    public ApplyPowerActionBuilder(int amount, int upgradedAmount, PowerFunction buildPower, Supplier<String> effectName) {
        super(amount, upgradedAmount);
        this.buildPower = buildPower;
        this.effectName = effectName;
    }

    public ApplyPowerActionBuilder setTarget(PowerTarget target) {
        this.target = target;
        this.doTarget = true;
        return this;
    }

    private boolean isTargetPlayer(CardBasic card) {
        if (this.doTarget) {
            return this.target == PowerTarget.PLAYER;
        }
        return card.target == AbstractCard.CardTarget.SELF;
    }

    @Override
    public String description(CardBasic card) {
        StringBuilder description = new StringBuilder();
        if (this.isTargetPlayer(card)) {
            description.append("Gain ");
        } else {
            description.append("Apply ");
        }
        if (this.usingMagicNumber()) {
            description.append("!M! ");
        } else {
            description.append(this.getAmount(card));
            description.append(" ");
        }
        description.append(this.effectName.get());
        description.append(". ");
        return description.toString();
    }

    @Override
    public AbstractGameAction buildAction(CardBasic card, AbstractPlayer player, AbstractMonster monster) {
        AbstractPower powerToApply = this.buildPower.apply(card, player, monster, this.getAmount(card));
        if (this.isTargetPlayer(card)) {
            return new ApplyPowerAction((AbstractCreature)player, (AbstractCreature)player, powerToApply, this.getAmount(card));
        }
        return new ApplyPowerAction((AbstractCreature)monster, (AbstractCreature)player, powerToApply, this.getAmount(card));
    }

    public static enum PowerTarget {
        PLAYER,
        MONSTER;

    }

    @FunctionalInterface
    public static interface PowerFunction {
        public AbstractPower apply(CardBasic var1, AbstractPlayer var2, AbstractMonster var3, Integer var4);
    }
}

