/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.AutoComplete;
import basemod.BaseMod;
import basemod.DevConsole;
import basemod.ModButton;
import basemod.ModLabel;
import basemod.ModLabeledToggleButton;
import basemod.ModPanel;
import basemod.interfaces.PostInitializeSubscriber;
import basemod.patches.whatmod.WhatMod;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Texture;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;

public class BaseModInit
implements PostInitializeSubscriber {
    public static final String MODNAME = "BaseMod";
    public static final String AUTHOR = "t-larson, test447, FlipskiZ, Haashi, Blank The Evil, kiooeht, robojumper, Skrelpoid";
    public static final String DESCRIPTION = "Modding API and Dev console.";
    private InputProcessor oldInputProcessor;
    public static final float BUTTON_X = 350.0f;
    public static final float BUTTON_Y = 650.0f;
    public static final float BUTTON_LABEL_X = 475.0f;
    public static final float BUTTON_LABEL_Y = 700.0f;
    public static final float BUTTON_ENABLE_X = 350.0f;
    public static final float BUTTON_ENABLE_Y = 600.0f;
    public static final float AUTOCOMPLETE_BUTTON_ENABLE_X = 350.0f;
    public static final float AUTOCOMPLETE_BUTTON_ENABLE_Y = 550.0f;
    public static final float AUTOCOMPLETE_LABEL_X = 350.0f;
    public static final float AUTOCOMPLETE_LABEL_Y = 425.0f;
    private static final String AUTOCOMPLETE_INFO = "Press L_Shift + Up/Down to scroll through suggestions.\nPress Tab or Right to complete the current command.\nPress Left to delete the last token.";
    public static final float WHATMOD_BUTTON_X = 350.0f;
    public static final float WHATMOD_BUTTON_Y = 350.0f;

    @Override
    public void receivePostInitialize() {
        ModPanel settingsPanel = new ModPanel();
        ModLabel buttonLabel = new ModLabel("", 475.0f, 700.0f, settingsPanel, me -> {
            me.text = me.parent.waitingOnEvent ? "Press key" : "Change console hotkey (" + Input.Keys.toString((int)DevConsole.toggleKey) + ")";
        });
        settingsPanel.addUIElement(buttonLabel);
        ModButton consoleKeyButton = new ModButton(350.0f, 650.0f, settingsPanel, me -> {
            me.parent.waitingOnEvent = true;
            this.oldInputProcessor = Gdx.input.getInputProcessor();
            Gdx.input.setInputProcessor((InputProcessor)new InputAdapter((ModButton)me){
                final /* synthetic */ ModButton val$me;
                {
                    this.val$me = modButton;
                }

                public boolean keyUp(int keycode) {
                    DevConsole.toggleKey = keycode;
                    BaseMod.setString("console-key", Input.Keys.toString((int)keycode));
                    this.val$me.parent.waitingOnEvent = false;
                    Gdx.input.setInputProcessor(BaseModInit.this.oldInputProcessor);
                    return true;
                }
            });
        });
        settingsPanel.addUIElement(consoleKeyButton);
        ModLabeledToggleButton enableConsole = new ModLabeledToggleButton("Enable dev console", 350.0f, 600.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, DevConsole.enabled, settingsPanel, label -> {}, button -> {
            DevConsole.enabled = button.enabled;
            BaseMod.setBoolean("console-enabled", button.enabled);
        });
        settingsPanel.addUIElement(enableConsole);
        ModLabel autoCompleteInfo = new ModLabel(AutoComplete.enabled ? AUTOCOMPLETE_INFO : "", 350.0f, 425.0f, settingsPanel, me -> {});
        settingsPanel.addUIElement(autoCompleteInfo);
        ModLabeledToggleButton enableAutoComplete = new ModLabeledToggleButton("Enable Autocompletion", 350.0f, 550.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, AutoComplete.enabled, settingsPanel, label -> {}, button -> {
            AutoComplete.enabled = button.enabled;
            AutoComplete.resetAndSuggest();
            BaseMod.setString("autocomplete-enabled", button.enabled ? "true" : "false");
            autoCompleteInfo.text = AutoComplete.enabled ? AUTOCOMPLETE_INFO : "";
        });
        settingsPanel.addUIElement(enableAutoComplete);
        ModLabeledToggleButton enableWhatMod = new ModLabeledToggleButton("Enable mod name in tooltips", 350.0f, 350.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, WhatMod.enabled, settingsPanel, label -> {}, button -> {
            WhatMod.enabled = button.enabled;
            BaseMod.setBoolean("whatmod-enabled", button.enabled);
        });
        settingsPanel.addUIElement(enableWhatMod);
        settingsPanel.addUIElement(new ModLabel("Must restart game to take effect", 350.0f, 320.0f, settingsPanel, me -> {}));
        Texture badgeTexture = ImageMaster.loadImage((String)"img/BaseModBadge.png");
        BaseMod.registerModBadge(badgeTexture, MODNAME, AUTHOR, DESCRIPTION, settingsPanel);
        BaseMod.initializeUnderscoreCardIDs();
        BaseMod.initializeUnderscorePotionIDs();
        BaseMod.initializeUnderscoreEventIDs();
        BaseMod.initializeUnderscoreRelicIDs();
        BaseMod.initializeEncounters();
    }
}

